@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HybridAKSNodePoolStatus defines the observed state of HybridAKSNodePool
 * @property errorMessage ErrorMessage - Error messages during creation of cluster
 * @property provisioningStatus Contains Provisioning errors
 * @property readyReplicas Total number of ready machines targeted by this deployment.
 * @property replicas Total number of non-terminated machines targeted by this deployment
 */
public data class AgentPoolProvisioningStatusStatusArgs(
    public val errorMessage: Output<String>? = null,
    public val provisioningStatus: Output<AgentPoolProvisioningStatusProvisioningStatusArgs>? = null,
    public val readyReplicas: Output<Int>? = null,
    public val replicas: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusStatusArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusStatusArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.AgentPoolProvisioningStatusStatusArgs.builder()
            .errorMessage(errorMessage?.applyValue({ args0 -> args0 }))
            .provisioningStatus(
                provisioningStatus?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .readyReplicas(readyReplicas?.applyValue({ args0 -> args0 }))
            .replicas(replicas?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPoolProvisioningStatusStatusArgs].
 */
@PulumiTagMarker
public class AgentPoolProvisioningStatusStatusArgsBuilder internal constructor() {
    private var errorMessage: Output<String>? = null

    private var provisioningStatus: Output<AgentPoolProvisioningStatusProvisioningStatusArgs>? = null

    private var readyReplicas: Output<Int>? = null

    private var replicas: Output<Int>? = null

    /**
     * @param value ErrorMessage - Error messages during creation of cluster
     */
    @JvmName("yklcgajoepgarjjo")
    public suspend fun errorMessage(`value`: Output<String>) {
        this.errorMessage = value
    }

    /**
     * @param value Contains Provisioning errors
     */
    @JvmName("oljesmbusvdkkcjx")
    public suspend
    fun provisioningStatus(`value`: Output<AgentPoolProvisioningStatusProvisioningStatusArgs>) {
        this.provisioningStatus = value
    }

    /**
     * @param value Total number of ready machines targeted by this deployment.
     */
    @JvmName("gmkwhjgpkfdlrnxu")
    public suspend fun readyReplicas(`value`: Output<Int>) {
        this.readyReplicas = value
    }

    /**
     * @param value Total number of non-terminated machines targeted by this deployment
     */
    @JvmName("dmcucoubsbolbcng")
    public suspend fun replicas(`value`: Output<Int>) {
        this.replicas = value
    }

    /**
     * @param value ErrorMessage - Error messages during creation of cluster
     */
    @JvmName("xyfsarsiuahdqldw")
    public suspend fun errorMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorMessage = mapped
    }

    /**
     * @param value Contains Provisioning errors
     */
    @JvmName("xqpvrnaxegwyjkmv")
    public suspend
    fun provisioningStatus(`value`: AgentPoolProvisioningStatusProvisioningStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningStatus = mapped
    }

    /**
     * @param argument Contains Provisioning errors
     */
    @JvmName("agrphcwavgjakffh")
    public suspend
    fun provisioningStatus(argument: suspend AgentPoolProvisioningStatusProvisioningStatusArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPoolProvisioningStatusProvisioningStatusArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.provisioningStatus = mapped
    }

    /**
     * @param value Total number of ready machines targeted by this deployment.
     */
    @JvmName("ofqspmjkwjdqgnjc")
    public suspend fun readyReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readyReplicas = mapped
    }

    /**
     * @param value Total number of non-terminated machines targeted by this deployment
     */
    @JvmName("lrwoiqndygvnfuno")
    public suspend fun replicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    internal fun build(): AgentPoolProvisioningStatusStatusArgs =
        AgentPoolProvisioningStatusStatusArgs(
            errorMessage = errorMessage,
            provisioningStatus = provisioningStatus,
            readyReplicas = readyReplicas,
            replicas = replicas,
        )
}
