@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * InfraStorageProfile - List of infra storage profiles for the provisioned cluster
 * @property storageSpaceIds Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
 */
public data class CloudProviderProfileInfraStorageProfileArgs(
    public val storageSpaceIds: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraStorageProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.CloudProviderProfileInfraStorageProfileArgs.builder()
            .storageSpaceIds(storageSpaceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CloudProviderProfileInfraStorageProfileArgs].
 */
@PulumiTagMarker
public class CloudProviderProfileInfraStorageProfileArgsBuilder internal constructor() {
    private var storageSpaceIds: Output<List<String>>? = null

    /**
     * @param value Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
     */
    @JvmName("nkwmnegybdloxoue")
    public suspend fun storageSpaceIds(`value`: Output<List<String>>) {
        this.storageSpaceIds = value
    }

    @JvmName("vvvjcmbnwtgwhaqe")
    public suspend fun storageSpaceIds(vararg values: Output<String>) {
        this.storageSpaceIds = Output.all(values.asList())
    }

    /**
     * @param values Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
     */
    @JvmName("fculfqkcpkvswfhb")
    public suspend fun storageSpaceIds(values: List<Output<String>>) {
        this.storageSpaceIds = Output.all(values)
    }

    /**
     * @param value Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
     */
    @JvmName("dqgggcehtadrtcrd")
    public suspend fun storageSpaceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSpaceIds = mapped
    }

    /**
     * @param values Reference to azure resource corresponding to the new HybridAKSStorage object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/storageSpaces/{storageSpaceName}
     */
    @JvmName("rbknbsxpbmpmwgqh")
    public suspend fun storageSpaceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageSpaceIds = mapped
    }

    internal fun build(): CloudProviderProfileInfraStorageProfileArgs =
        CloudProviderProfileInfraStorageProfileArgs(
            storageSpaceIds = storageSpaceIds,
        )
}
