@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.ControlPlaneEndpointProfileControlPlaneEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API server endpoint for the control plane
 * @property hostIP Host IP address for API server
 * @property port Port for the API server
 */
public data class ControlPlaneEndpointProfileControlPlaneEndpointArgs(
    public val hostIP: Output<String>? = null,
    public val port: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.ControlPlaneEndpointProfileControlPlaneEndpointArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.ControlPlaneEndpointProfileControlPlaneEndpointArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.ControlPlaneEndpointProfileControlPlaneEndpointArgs.builder()
            .hostIP(hostIP?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlPlaneEndpointProfileControlPlaneEndpointArgs].
 */
@PulumiTagMarker
public class ControlPlaneEndpointProfileControlPlaneEndpointArgsBuilder internal constructor() {
    private var hostIP: Output<String>? = null

    private var port: Output<String>? = null

    /**
     * @param value Host IP address for API server
     */
    @JvmName("prpandhrrgchbcbk")
    public suspend fun hostIP(`value`: Output<String>) {
        this.hostIP = value
    }

    /**
     * @param value Port for the API server
     */
    @JvmName("fqmfwjpplxwodvxp")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Host IP address for API server
     */
    @JvmName("fgqutuuqaasdbhhm")
    public suspend fun hostIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostIP = mapped
    }

    /**
     * @param value Port for the API server
     */
    @JvmName("gogaanbkgxlybeev")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ControlPlaneEndpointProfileControlPlaneEndpointArgs =
        ControlPlaneEndpointProfileControlPlaneEndpointArgs(
            hostIP = hostIP,
            port = port,
        )
}
