@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.GetVirtualNetworkRetrievePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualNetworksName Parameter for the name of the virtual network
 */
public data class GetVirtualNetworkRetrievePlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworksName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.GetVirtualNetworkRetrievePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.GetVirtualNetworkRetrievePlainArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.GetVirtualNetworkRetrievePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworksName(virtualNetworksName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkRetrievePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkRetrievePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworksName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kmwupkbdnpclsypt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter for the name of the virtual network
     */
    @JvmName("kuwelogwirihlobv")
    public suspend fun virtualNetworksName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworksName = mapped
    }

    internal fun build(): GetVirtualNetworkRetrievePlainArgs = GetVirtualNetworkRetrievePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworksName = virtualNetworksName ?: throw PulumiNullFieldException("virtualNetworksName"),
    )
}
