@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HybridAKSStorageSpec defines the desired state of HybridAKSStorage
 * @property hciStorageProfile
 * @property status HybridAKSStorageStatus defines the observed state of HybridAKSStorage
 * @property vmwareStorageProfile
 */
public data class StorageSpacesPropertiesArgs(
    public val hciStorageProfile: Output<StorageSpacesPropertiesHciStorageProfileArgs>? = null,
    public val status: Output<StorageSpacesPropertiesStatusArgs>? = null,
    public val vmwareStorageProfile: Output<StorageSpacesPropertiesVmwareStorageProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesArgs.builder()
            .hciStorageProfile(hciStorageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmwareStorageProfile(
                vmwareStorageProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [StorageSpacesPropertiesArgs].
 */
@PulumiTagMarker
public class StorageSpacesPropertiesArgsBuilder internal constructor() {
    private var hciStorageProfile: Output<StorageSpacesPropertiesHciStorageProfileArgs>? = null

    private var status: Output<StorageSpacesPropertiesStatusArgs>? = null

    private var vmwareStorageProfile: Output<StorageSpacesPropertiesVmwareStorageProfileArgs>? = null

    /**
     * @param value
     */
    @JvmName("iqyutnnaoxpsldia")
    public suspend
    fun hciStorageProfile(`value`: Output<StorageSpacesPropertiesHciStorageProfileArgs>) {
        this.hciStorageProfile = value
    }

    /**
     * @param value HybridAKSStorageStatus defines the observed state of HybridAKSStorage
     */
    @JvmName("fwwaslphlsvqwihe")
    public suspend fun status(`value`: Output<StorageSpacesPropertiesStatusArgs>) {
        this.status = value
    }

    /**
     * @param value
     */
    @JvmName("bnhkgaerkmncbdcn")
    public suspend
    fun vmwareStorageProfile(`value`: Output<StorageSpacesPropertiesVmwareStorageProfileArgs>) {
        this.vmwareStorageProfile = value
    }

    /**
     * @param value
     */
    @JvmName("pjeggiayabblrmoc")
    public suspend fun hciStorageProfile(`value`: StorageSpacesPropertiesHciStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hciStorageProfile = mapped
    }

    /**
     * @param argument
     */
    @JvmName("asgloyrpaoapxyag")
    public suspend
    fun hciStorageProfile(argument: suspend StorageSpacesPropertiesHciStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSpacesPropertiesHciStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hciStorageProfile = mapped
    }

    /**
     * @param value HybridAKSStorageStatus defines the observed state of HybridAKSStorage
     */
    @JvmName("mqmkcbifvivnpjto")
    public suspend fun status(`value`: StorageSpacesPropertiesStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param argument HybridAKSStorageStatus defines the observed state of HybridAKSStorage
     */
    @JvmName("wnsdaixamviykokq")
    public suspend fun status(argument: suspend StorageSpacesPropertiesStatusArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSpacesPropertiesStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("hprgsnrwhwckkmyg")
    public suspend
    fun vmwareStorageProfile(`value`: StorageSpacesPropertiesVmwareStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmwareStorageProfile = mapped
    }

    /**
     * @param argument
     */
    @JvmName("chqbfpkfkvvpuhao")
    public suspend
    fun vmwareStorageProfile(argument: suspend StorageSpacesPropertiesVmwareStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSpacesPropertiesVmwareStorageProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vmwareStorageProfile = mapped
    }

    internal fun build(): StorageSpacesPropertiesArgs = StorageSpacesPropertiesArgs(
        hciStorageProfile = hciStorageProfile,
        status = status,
        vmwareStorageProfile = vmwareStorageProfile,
    )
}
