@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesErrorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property code
 * @property message
 */
public data class StorageSpacesPropertiesErrorArgs(
    public val code: Output<String>? = null,
    public val message: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesErrorArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesErrorArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesErrorArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageSpacesPropertiesErrorArgs].
 */
@PulumiTagMarker
public class StorageSpacesPropertiesErrorArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var message: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ongtdnkhsqgbgoii")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value
     */
    @JvmName("gxpcvxwnservfqud")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value
     */
    @JvmName("ekolscnhnjofqlwv")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value
     */
    @JvmName("rsxhmgbeouylfmve")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): StorageSpacesPropertiesErrorArgs = StorageSpacesPropertiesErrorArgs(
        code = code,
        message = message,
    )
}
