@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesProvisioningStatusArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contains Provisioning errors
 * @property error
 * @property operationId
 * @property phase Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
 * @property status
 */
public data class StorageSpacesPropertiesProvisioningStatusArgs(
    public val error: Output<StorageSpacesPropertiesErrorArgs>? = null,
    public val operationId: Output<String>? = null,
    public val phase: Output<String>? = null,
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesProvisioningStatusArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesProvisioningStatusArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.StorageSpacesPropertiesProvisioningStatusArgs.builder()
            .error(error?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .operationId(operationId?.applyValue({ args0 -> args0 }))
            .phase(phase?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageSpacesPropertiesProvisioningStatusArgs].
 */
@PulumiTagMarker
public class StorageSpacesPropertiesProvisioningStatusArgsBuilder internal constructor() {
    private var error: Output<StorageSpacesPropertiesErrorArgs>? = null

    private var operationId: Output<String>? = null

    private var phase: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lvjcttnekjvndqhr")
    public suspend fun error(`value`: Output<StorageSpacesPropertiesErrorArgs>) {
        this.error = value
    }

    /**
     * @param value
     */
    @JvmName("ipblcifdcixcekdb")
    public suspend fun operationId(`value`: Output<String>) {
        this.operationId = value
    }

    /**
     * @param value Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
     */
    @JvmName("xutpgblrlxspmmne")
    public suspend fun phase(`value`: Output<String>) {
        this.phase = value
    }

    /**
     * @param value
     */
    @JvmName("icgqnvdyjiktvodi")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value
     */
    @JvmName("rbsvsqwqdgmpfobo")
    public suspend fun error(`value`: StorageSpacesPropertiesErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param argument
     */
    @JvmName("riepjvcudtjapbub")
    public suspend fun error(argument: suspend StorageSpacesPropertiesErrorArgsBuilder.() -> Unit) {
        val toBeMapped = StorageSpacesPropertiesErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.error = mapped
    }

    /**
     * @param value
     */
    @JvmName("omxvvqgkjerjhqtw")
    public suspend fun operationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationId = mapped
    }

    /**
     * @param value Phase represents the current phase of cluster actuation. E.g. Pending, Running, Terminating, Failed etc.
     */
    @JvmName("updooudonocjchja")
    public suspend fun phase(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phase = mapped
    }

    /**
     * @param value
     */
    @JvmName("lrfbvcuqjnyecivh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): StorageSpacesPropertiesProvisioningStatusArgs =
        StorageSpacesPropertiesProvisioningStatusArgs(
            error = error,
            operationId = operationId,
            phase = phase,
            status = status,
        )
}
