@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.inputs

import com.pulumi.azurenative.hybridcontainerservice.inputs.WindowsProfileArgs.builder
import com.pulumi.azurenative.hybridcontainerservice.kotlin.enums.LicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * WindowsProfile - Profile for Windows VMs in the container service cluster.
 * @property adminPassword AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
 * @property adminUsername AdminUsername - Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
 * @property enableCsiProxy EnableCSIProxy - Whether to enable CSI proxy.
 * @property licenseType LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
 */
public data class WindowsProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val enableCsiProxy: Output<Boolean>? = null,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridcontainerservice.inputs.WindowsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridcontainerservice.inputs.WindowsProfileArgs =
        com.pulumi.azurenative.hybridcontainerservice.inputs.WindowsProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .enableCsiProxy(enableCsiProxy?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WindowsProfileArgs].
 */
@PulumiTagMarker
public class WindowsProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var enableCsiProxy: Output<Boolean>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    /**
     * @param value AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
     */
    @JvmName("tvxehqsmdbebjrif")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value AdminUsername - Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
     */
    @JvmName("klkbqikvvbevkqdk")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value EnableCSIProxy - Whether to enable CSI proxy.
     */
    @JvmName("dgofsckbjuhangbw")
    public suspend fun enableCsiProxy(`value`: Output<Boolean>) {
        this.enableCsiProxy = value
    }

    /**
     * @param value LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
     */
    @JvmName("gxgjeohtlrhqtkhv")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value AdminPassword - Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
     */
    @JvmName("bnpfvkfhlmljqhdf")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value AdminUsername - Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
     */
    @JvmName("apmumvkegqrmevma")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value EnableCSIProxy - Whether to enable CSI proxy.
     */
    @JvmName("xcbvguyqjacsbbia")
    public suspend fun enableCsiProxy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCsiProxy = mapped
    }

    /**
     * @param value LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
     */
    @JvmName("vllevwqsfesinylg")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
     */
    @JvmName("uiyqxlttqgvhawgu")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value LicenseType - The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs. Possible values include: 'None', 'Windows_Server'
     */
    @JvmName("hypbxxriiqvibbws")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    internal fun build(): WindowsProfileArgs = WindowsProfileArgs(
        adminPassword = adminPassword,
        adminUsername = adminUsername,
        enableCsiProxy = enableCsiProxy,
        licenseType = licenseType,
    )
}
