@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Suppress

/**
 * CloudProviderProfile - The underlying cloud infra provider properties.
 * @property infraNetworkProfile InfraNetworkProfile - List of infra network profiles for the provisioned cluster
 * @property infraStorageProfile InfraStorageProfile - List of infra storage profiles for the provisioned cluster
 */
public data class CloudProviderProfileResponse(
    public val infraNetworkProfile: CloudProviderProfileResponseInfraNetworkProfile? = null,
    public val infraStorageProfile: CloudProviderProfileResponseInfraStorageProfile? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.CloudProviderProfileResponse):
            CloudProviderProfileResponse = CloudProviderProfileResponse(
            infraNetworkProfile = javaType.infraNetworkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.CloudProviderProfileResponseInfraNetworkProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
            infraStorageProfile = javaType.infraStorageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.CloudProviderProfileResponseInfraStorageProfile.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
