@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InfraNetworkProfile - List of infra network profiles for the provisioned cluster
 * @property vnetSubnetIds Array of references to azure resource corresponding to the new HybridAKSNetwork object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridContainerService/virtualNetworks/{virtualNetworkName}
 */
public data class CloudProviderProfileResponseInfraNetworkProfile(
    public val vnetSubnetIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.CloudProviderProfileResponseInfraNetworkProfile):
            CloudProviderProfileResponseInfraNetworkProfile =
            CloudProviderProfileResponseInfraNetworkProfile(
                vnetSubnetIds = javaType.vnetSubnetIds().map({ args0 -> args0 }),
            )
    }
}
