@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configurations for provisioning the cluster with HTTP proxy servers.
 * @property httpProxy The HTTP proxy server endpoint to use.
 * @property httpsProxy The HTTPS proxy server endpoint to use.
 * @property noProxy The endpoints that should not go through proxy.
 * @property trustedCa Alternative CA cert to use for connecting to proxy servers.
 * @property username Username to use for connecting to proxy server
 */
public data class HttpProxyConfigResponseResponse(
    public val httpProxy: String? = null,
    public val httpsProxy: String? = null,
    public val noProxy: List<String>? = null,
    public val trustedCa: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.HttpProxyConfigResponseResponse):
            HttpProxyConfigResponseResponse = HttpProxyConfigResponseResponse(
            httpProxy = javaType.httpProxy().map({ args0 -> args0 }).orElse(null),
            httpsProxy = javaType.httpsProxy().map({ args0 -> args0 }).orElse(null),
            noProxy = javaType.noProxy().map({ args0 -> args0 }),
            trustedCa = javaType.trustedCa().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
