@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property aadProfile AAD profile for the provisioned cluster.
 * @property addonProfiles AddonProfiles - Profile of managed cluster add-on.
 * @property agentPoolProfiles The agent pools of the cluster.
 * @property cloudProviderProfile The underlying cloud infra provider properties.
 * @property controlPlane ControlPlane - ControlPlane Configuration
 * @property enableRbac EnableRBAC - Whether to enable Kubernetes Role-Based Access Control.
 * @property features Additional features specs like Arc Agent Onboarding.
 * @property httpProxyConfig HttpProxyConfig - Configurations for provisioning the cluster with HTTP proxy servers.
 * @property kubernetesVersion KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
 * @property linuxProfile LinuxProfile - The profile for Linux VMs in the Provisioned Cluster.
 * @property networkProfile NetworkProfile - Profile of network configuration.
 * @property nodeResourceGroup NodeResourceGroup - Name of the resource group containing agent pool nodes.
 * @property provisioningState
 * @property status HybridAKSClusterStatus defines the observed state of HybridAKSCluster
 * @property windowsProfile WindowsProfile - Profile for Windows VMs in the Provisioned Cluster.
 */
public data class ProvisionedClustersResponsePropertiesResponse(
    public val aadProfile: AADProfileResponseResponse? = null,
    public val addonProfiles: Map<String, AddonProfilesResponse>? = null,
    public val agentPoolProfiles: List<NamedAgentPoolProfileResponse>? = null,
    public val cloudProviderProfile: CloudProviderProfileResponse? = null,
    public val controlPlane: ControlPlaneProfileResponse? = null,
    public val enableRbac: Boolean? = null,
    public val features: ProvisionedClustersCommonPropertiesResponseFeatures? = null,
    public val httpProxyConfig: HttpProxyConfigResponseResponse? = null,
    public val kubernetesVersion: String? = null,
    public val linuxProfile: LinuxProfilePropertiesResponse? = null,
    public val networkProfile: NetworkProfileResponse? = null,
    public val nodeResourceGroup: String? = null,
    public val provisioningState: String,
    public val status: ProvisionedClustersCommonPropertiesResponseStatus,
    public val windowsProfile: WindowsProfileResponseResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridcontainerservice.outputs.ProvisionedClustersResponsePropertiesResponse):
            ProvisionedClustersResponsePropertiesResponse =
            ProvisionedClustersResponsePropertiesResponse(
                aadProfile = javaType.aadProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AADProfileResponseResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                addonProfiles = javaType.addonProfiles().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.AddonProfilesResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                agentPoolProfiles = javaType.agentPoolProfiles().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.NamedAgentPoolProfileResponse.Companion.toKotlin(args0)
                    })
                }),
                cloudProviderProfile = javaType.cloudProviderProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.CloudProviderProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                controlPlane = javaType.controlPlane().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ControlPlaneProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enableRbac = javaType.enableRbac().map({ args0 -> args0 }).orElse(null),
                features = javaType.features().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersCommonPropertiesResponseFeatures.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                httpProxyConfig = javaType.httpProxyConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.HttpProxyConfigResponseResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                kubernetesVersion = javaType.kubernetesVersion().map({ args0 -> args0 }).orElse(null),
                linuxProfile = javaType.linuxProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.LinuxProfilePropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                networkProfile = javaType.networkProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                nodeResourceGroup = javaType.nodeResourceGroup().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                status = javaType.status().let({ args0 ->
                    com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.ProvisionedClustersCommonPropertiesResponseStatus.Companion.toKotlin(args0)
                }),
                windowsProfile = javaType.windowsProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridcontainerservice.kotlin.outputs.WindowsProfileResponseResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
