@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin

import com.pulumi.azurenative.hybriddata.kotlin.outputs.CustomerSecretResponse
import com.pulumi.azurenative.hybriddata.kotlin.outputs.ScheduleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.hybriddata.kotlin.outputs.CustomerSecretResponse.Companion.toKotlin as customerSecretResponseToKotlin
import com.pulumi.azurenative.hybriddata.kotlin.outputs.ScheduleResponse.Companion.toKotlin as scheduleResponseToKotlin

/**
 * Builder for [JobDefinition].
 */
@PulumiTagMarker
public class JobDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobDefinitionArgs = JobDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobDefinitionArgsBuilder.() -> Unit) {
        val builder = JobDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JobDefinition {
        val builtJavaResource = com.pulumi.azurenative.hybriddata.JobDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobDefinition(builtJavaResource)
    }
}

/**
 * Job Definition.
 * Azure REST API version: 2019-06-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * ## Example Usage
 * ### JobDefinitions_CreateOrUpdatePUT83
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobDefinition = new AzureNative.HybridData.JobDefinition("jobDefinition", new()
 *     {
 *         DataManagerName = "TestAzureSDKOperations",
 *         DataServiceInput =
 *         {
 *             { "AzureStorageType", "Blob" },
 *             { "BackupChoice", "UseExistingLatest" },
 *             { "ContainerName", "containerfromtest" },
 *             { "DeviceName", "8600-SHG0997877L71FC" },
 *             { "FileNameFilter", "*" },
 *             { "IsDirectoryMode", false },
 *             { "RootDirectories", new[]
 *             {
 *                 "\\",
 *             } },
 *             { "VolumeNames", new[]
 *             {
 *                 "TestAutomation",
 *             } },
 *         },
 *         DataServiceName = "DataTransformation",
 *         DataSinkId = "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestAzureStorage1",
 *         DataSourceId = "/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestStorSimpleSource1",
 *         JobDefinitionName = "jobdeffromtestcode1",
 *         ResourceGroupName = "ResourceGroupForSDKTest",
 *         RunLocation = AzureNative.HybridData.RunLocation.Westus,
 *         State = AzureNative.HybridData.State.Enabled,
 *         UserConfirmation = AzureNative.HybridData.UserConfirmation.Required,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybriddata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybriddata.NewJobDefinition(ctx, "jobDefinition", &hybriddata.JobDefinitionArgs{
 * 			DataManagerName: pulumi.String("TestAzureSDKOperations"),
 * 			DataServiceInput: pulumi.Any{
 * 				AzureStorageType: "Blob",
 * 				BackupChoice:     "UseExistingLatest",
 * 				ContainerName:    "containerfromtest",
 * 				DeviceName:       "8600-SHG0997877L71FC",
 * 				FileNameFilter:   "*",
 * 				IsDirectoryMode:  false,
 * 				RootDirectories: []string{
 * 					"\\",
 * 				},
 * 				VolumeNames: []string{
 * 					"TestAutomation",
 * 				},
 * 			},
 * 			DataServiceName:   pulumi.String("DataTransformation"),
 * 			DataSinkId:        pulumi.String("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestAzureStorage1"),
 * 			DataSourceId:      pulumi.String("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestStorSimpleSource1"),
 * 			JobDefinitionName: pulumi.String("jobdeffromtestcode1"),
 * 			ResourceGroupName: pulumi.String("ResourceGroupForSDKTest"),
 * 			RunLocation:       hybriddata.RunLocationWestus,
 * 			State:             hybriddata.StateEnabled,
 * 			UserConfirmation:  hybriddata.UserConfirmationRequired,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybriddata.JobDefinition;
 * import com.pulumi.azurenative.hybriddata.JobDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobDefinition = new JobDefinition("jobDefinition", JobDefinitionArgs.builder()
 *             .dataManagerName("TestAzureSDKOperations")
 *             .dataServiceInput(Map.ofEntries(
 *                 Map.entry("AzureStorageType", "Blob"),
 *                 Map.entry("BackupChoice", "UseExistingLatest"),
 *                 Map.entry("ContainerName", "containerfromtest"),
 *                 Map.entry("DeviceName", "8600-SHG0997877L71FC"),
 *                 Map.entry("FileNameFilter", "*"),
 *                 Map.entry("IsDirectoryMode", false),
 *                 Map.entry("RootDirectories", "\\"),
 *                 Map.entry("VolumeNames", "TestAutomation")
 *             ))
 *             .dataServiceName("DataTransformation")
 *             .dataSinkId("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestAzureStorage1")
 *             .dataSourceId("/subscriptions/6e0219f5-327a-4365-904f-05eed4227ad7/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.HybridData/dataManagers/TestAzureSDKOperations/dataStores/TestStorSimpleSource1")
 *             .jobDefinitionName("jobdeffromtestcode1")
 *             .resourceGroupName("ResourceGroupForSDKTest")
 *             .runLocation("westus")
 *             .state("Enabled")
 *             .userConfirmation("Required")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybriddata:JobDefinition jobdeffromtestcode1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridData/dataManagers/{dataManagerName}/dataServices/{dataServiceName}/jobDefinitions/{jobDefinitionName}
 * ```
 */
public class JobDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.hybriddata.JobDefinition,
) : KotlinCustomResource(javaResource, JobDefinitionMapper) {
    /**
     * List of customer secrets containing a key identifier and key value. The key identifier is a way for the specific data source to understand the key. Value contains customer secret encrypted by the encryptionKeys.
     */
    public val customerSecrets: Output<List<CustomerSecretResponse>>?
        get() = javaResource.customerSecrets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        customerSecretResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A generic json used differently by each data service type.
     */
    public val dataServiceInput: Output<Any>?
        get() = javaResource.dataServiceInput().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Data Sink Id associated to the job definition.
     */
    public val dataSinkId: Output<String>
        get() = javaResource.dataSinkId().applyValue({ args0 -> args0 })

    /**
     * Data Source Id associated to the job definition.
     */
    public val dataSourceId: Output<String>
        get() = javaResource.dataSourceId().applyValue({ args0 -> args0 })

    /**
     * Last modified time of the job definition.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the object.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * This is the preferred geo location for the job to run.
     */
    public val runLocation: Output<String>?
        get() = javaResource.runLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schedule for running the job definition
     */
    public val schedules: Output<List<ScheduleResponse>>?
        get() = javaResource.schedules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> scheduleResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * State of the job definition.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Enum to detect if user confirmation is required. If not passed will default to NotRequired.
     */
    public val userConfirmation: Output<String>?
        get() = javaResource.userConfirmation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object JobDefinitionMapper : ResourceMapper<JobDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybriddata.JobDefinition::class == javaResource::class

    override fun map(javaResource: Resource): JobDefinition = JobDefinition(
        javaResource as
            com.pulumi.azurenative.hybriddata.JobDefinition,
    )
}

/**
 * @see [JobDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobDefinition].
 */
public suspend fun jobDefinition(
    name: String,
    block: suspend JobDefinitionResourceBuilder.() -> Unit,
): JobDefinition {
    val builder = JobDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobDefinition(name: String): JobDefinition {
    val builder = JobDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
