@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.inputs

import com.pulumi.azurenative.hybriddata.inputs.GetDataManagerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataManagerName The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property resourceGroupName The Resource Group Name
 */
public data class GetDataManagerPlainArgs(
    public val dataManagerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.inputs.GetDataManagerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.inputs.GetDataManagerPlainArgs =
        com.pulumi.azurenative.hybriddata.inputs.GetDataManagerPlainArgs.builder()
            .dataManagerName(dataManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataManagerPlainArgs].
 */
@PulumiTagMarker
public class GetDataManagerPlainArgsBuilder internal constructor() {
    private var dataManagerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DataManager Resource within the specified resource group. DataManager names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("gfpqsmqejviexxyq")
    public suspend fun dataManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataManagerName = mapped
    }

    /**
     * @param value The Resource Group Name
     */
    @JvmName("jlperrnhmtgdcimm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataManagerPlainArgs = GetDataManagerPlainArgs(
        dataManagerName = dataManagerName ?: throw PulumiNullFieldException("dataManagerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
