@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybriddata.kotlin.inputs

import com.pulumi.azurenative.hybriddata.inputs.ScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schedule for the job run.
 * @property name Name of the schedule.
 * @property policyList A list of repetition intervals in ISO 8601 format.
 */
public data class ScheduleArgs(
    public val name: Output<String>? = null,
    public val policyList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybriddata.inputs.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.hybriddata.inputs.ScheduleArgs =
        com.pulumi.azurenative.hybriddata.inputs.ScheduleArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .policyList(policyList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var policyList: Output<List<String>>? = null

    /**
     * @param value Name of the schedule.
     */
    @JvmName("qqlnukffftpstbmu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of repetition intervals in ISO 8601 format.
     */
    @JvmName("povifdourrrcnowd")
    public suspend fun policyList(`value`: Output<List<String>>) {
        this.policyList = value
    }

    @JvmName("xmptldedihkpjija")
    public suspend fun policyList(vararg values: Output<String>) {
        this.policyList = Output.all(values.asList())
    }

    /**
     * @param values A list of repetition intervals in ISO 8601 format.
     */
    @JvmName("shluukylohhwyseq")
    public suspend fun policyList(values: List<Output<String>>) {
        this.policyList = Output.all(values)
    }

    /**
     * @param value Name of the schedule.
     */
    @JvmName("swokvildlovkjvdv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of repetition intervals in ISO 8601 format.
     */
    @JvmName("cxhsjmrmmvqcjnvx")
    public suspend fun policyList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyList = mapped
    }

    /**
     * @param values A list of repetition intervals in ISO 8601 format.
     */
    @JvmName("svlqvudwouxbcias")
    public suspend fun policyList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyList = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        name = name,
        policyList = policyList,
    )
}
