@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.ArtifactManifestArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ArtifactManifestPropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ArtifactManifestPropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Artifact manifest properties.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update the artifact manifest resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactManifest = new AzureNative.HybridNetwork.ArtifactManifest("artifactManifest", new()
 *     {
 *         ArtifactManifestName = "TestManifest",
 *         ArtifactStoreName = "TestArtifactStore",
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ArtifactManifestPropertiesFormatArgs
 *         {
 *             Artifacts = new[]
 *             {
 *                 new AzureNative.HybridNetwork.Inputs.ManifestArtifactFormatArgs
 *                 {
 *                     ArtifactName = "fed-rbac",
 *                     ArtifactType = "OCIArtifact",
 *                     ArtifactVersion = "1.0.0",
 *                 },
 *                 new AzureNative.HybridNetwork.Inputs.ManifestArtifactFormatArgs
 *                 {
 *                     ArtifactName = "nginx",
 *                     ArtifactType = "OCIArtifact",
 *                     ArtifactVersion = "v1",
 *                 },
 *             },
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewArtifactManifest(ctx, "artifactManifest", &hybridnetwork.ArtifactManifestArgs{
 * 			ArtifactManifestName: pulumi.String("TestManifest"),
 * 			ArtifactStoreName:    pulumi.String("TestArtifactStore"),
 * 			Location:             pulumi.String("eastus"),
 * 			Properties: hybridnetwork.ArtifactManifestPropertiesFormatResponse{
 * 				Artifacts: hybridnetwork.ManifestArtifactFormatArray{
 * 					&hybridnetwork.ManifestArtifactFormatArgs{
 * 						ArtifactName:    pulumi.String("fed-rbac"),
 * 						ArtifactType:    pulumi.String("OCIArtifact"),
 * 						ArtifactVersion: pulumi.String("1.0.0"),
 * 					},
 * 					&hybridnetwork.ManifestArtifactFormatArgs{
 * 						ArtifactName:    pulumi.String("nginx"),
 * 						ArtifactType:    pulumi.String("OCIArtifact"),
 * 						ArtifactVersion: pulumi.String("v1"),
 * 					},
 * 				},
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactManifest;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactManifestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactManifest = new ArtifactManifest("artifactManifest", ArtifactManifestArgs.builder()
 *             .artifactManifestName("TestManifest")
 *             .artifactStoreName("TestArtifactStore")
 *             .location("eastus")
 *             .properties(Map.of("artifacts",
 *                 Map.ofEntries(
 *                     Map.entry("artifactName", "fed-rbac"),
 *                     Map.entry("artifactType", "OCIArtifact"),
 *                     Map.entry("artifactVersion", "1.0.0")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("artifactName", "nginx"),
 *                     Map.entry("artifactType", "OCIArtifact"),
 *                     Map.entry("artifactVersion", "v1")
 *                 )))
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:ArtifactManifest TestManifest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}/artifactManifests/{artifactManifestName}
 * ```
 * @property artifactManifestName The name of the artifact manifest.
 * @property artifactStoreName The name of the artifact store.
 * @property location The geo-location where the resource lives
 * @property properties Artifact manifest properties.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ArtifactManifestArgs(
    public val artifactManifestName: Output<String>? = null,
    public val artifactStoreName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ArtifactManifestPropertiesFormatArgs>? = null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.ArtifactManifestArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.ArtifactManifestArgs =
        com.pulumi.azurenative.hybridnetwork.ArtifactManifestArgs.builder()
            .artifactManifestName(artifactManifestName?.applyValue({ args0 -> args0 }))
            .artifactStoreName(artifactStoreName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ArtifactManifestArgs].
 */
@PulumiTagMarker
public class ArtifactManifestArgsBuilder internal constructor() {
    private var artifactManifestName: Output<String>? = null

    private var artifactStoreName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ArtifactManifestPropertiesFormatArgs>? = null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the artifact manifest.
     */
    @JvmName("kdmdwirnhpwotasv")
    public suspend fun artifactManifestName(`value`: Output<String>) {
        this.artifactManifestName = value
    }

    /**
     * @param value The name of the artifact store.
     */
    @JvmName("xhygbogqtbuvxthr")
    public suspend fun artifactStoreName(`value`: Output<String>) {
        this.artifactStoreName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tynexkdqtusvebaq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Artifact manifest properties.
     */
    @JvmName("qolvffbowlolirba")
    public suspend fun properties(`value`: Output<ArtifactManifestPropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("wfqjwwysdrrpsdmm")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eabantargreaqwis")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pmbythmjytyhuvhm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the artifact manifest.
     */
    @JvmName("upphmgbrivsvxfxt")
    public suspend fun artifactManifestName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactManifestName = mapped
    }

    /**
     * @param value The name of the artifact store.
     */
    @JvmName("fvxorxhtrkcvcptn")
    public suspend fun artifactStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStoreName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nqbshkohcgxuitkr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Artifact manifest properties.
     */
    @JvmName("yiyvepjnotbjwddy")
    public suspend fun properties(`value`: ArtifactManifestPropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Artifact manifest properties.
     */
    @JvmName("fhybnxjhqiujikob")
    public suspend
    fun properties(argument: suspend ArtifactManifestPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = ArtifactManifestPropertiesFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("goqkwvyegwrycjvm")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uvjtssrttsvpsnbk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lmjoqtoypylrydsh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("knfjsjykiuhatmgu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ArtifactManifestArgs = ArtifactManifestArgs(
        artifactManifestName = artifactManifestName,
        artifactStoreName = artifactStoreName,
        location = location,
        properties = properties,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
