@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.ArtifactStoreArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ArtifactStorePropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.ArtifactStorePropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Artifact store properties.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update an artifact store of publisher resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactStore = new AzureNative.HybridNetwork.ArtifactStore("artifactStore", new()
 *     {
 *         ArtifactStoreName = "TestArtifactStore",
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.ArtifactStorePropertiesFormatArgs
 *         {
 *             ManagedResourceGroupConfiguration = new AzureNative.HybridNetwork.Inputs.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs
 *             {
 *                 Location = "eastus",
 *                 Name = "testRg",
 *             },
 *             ReplicationStrategy = "SingleReplication",
 *             StoreType = "AzureContainerRegistry",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewArtifactStore(ctx, "artifactStore", &hybridnetwork.ArtifactStoreArgs{
 * 			ArtifactStoreName: pulumi.String("TestArtifactStore"),
 * 			Location:          pulumi.String("eastus"),
 * 			Properties: hybridnetwork.ArtifactStorePropertiesFormatResponse{
 * 				ManagedResourceGroupConfiguration: &hybridnetwork.ArtifactStorePropertiesFormatManagedResourceGroupConfigurationArgs{
 * 					Location: pulumi.String("eastus"),
 * 					Name:     pulumi.String("testRg"),
 * 				},
 * 				ReplicationStrategy: pulumi.String("SingleReplication"),
 * 				StoreType:           pulumi.String("AzureContainerRegistry"),
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactStore;
 * import com.pulumi.azurenative.hybridnetwork.ArtifactStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactStore = new ArtifactStore("artifactStore", ArtifactStoreArgs.builder()
 *             .artifactStoreName("TestArtifactStore")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("managedResourceGroupConfiguration", Map.ofEntries(
 *                     Map.entry("location", "eastus"),
 *                     Map.entry("name", "testRg")
 *                 )),
 *                 Map.entry("replicationStrategy", "SingleReplication"),
 *                 Map.entry("storeType", "AzureContainerRegistry")
 *             ))
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:ArtifactStore TestArtifactStore /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/artifactStores/{artifactStoreName}
 * ```
 * @property artifactStoreName The name of the artifact store.
 * @property location The geo-location where the resource lives
 * @property properties ArtifactStores properties.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ArtifactStoreArgs(
    public val artifactStoreName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<ArtifactStorePropertiesFormatArgs>? = null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.ArtifactStoreArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.ArtifactStoreArgs =
        com.pulumi.azurenative.hybridnetwork.ArtifactStoreArgs.builder()
            .artifactStoreName(artifactStoreName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ArtifactStoreArgs].
 */
@PulumiTagMarker
public class ArtifactStoreArgsBuilder internal constructor() {
    private var artifactStoreName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<ArtifactStorePropertiesFormatArgs>? = null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the artifact store.
     */
    @JvmName("tvwywbblgfgfytqu")
    public suspend fun artifactStoreName(`value`: Output<String>) {
        this.artifactStoreName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jveugolnlgbpjgbr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ArtifactStores properties.
     */
    @JvmName("iypehymsvhciejwm")
    public suspend fun properties(`value`: Output<ArtifactStorePropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("pkbeodbfpxgwqodh")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wtvggaowmqdpaydg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("frpygsmsnrxbiykw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the artifact store.
     */
    @JvmName("sldarnjiiarffrwk")
    public suspend fun artifactStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStoreName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fuowmwjsfptuiohr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ArtifactStores properties.
     */
    @JvmName("qapffbalfrvptbjc")
    public suspend fun properties(`value`: ArtifactStorePropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument ArtifactStores properties.
     */
    @JvmName("wymqwdsjfsqsxhnk")
    public suspend
    fun properties(argument: suspend ArtifactStorePropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = ArtifactStorePropertiesFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("dielepmmkxfnthpb")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nylidrahndkekhdn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pjietooffwikcodh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qjjdcwklcfcslgdh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ArtifactStoreArgs = ArtifactStoreArgs(
        artifactStoreName = artifactStoreName,
        location = location,
        properties = properties,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
