@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionDefinitionGroupPropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionDefinitionGroupPropertiesFormatResponse.Companion.toKotlin as networkFunctionDefinitionGroupPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkFunctionDefinitionGroup].
 */
@PulumiTagMarker
public class NetworkFunctionDefinitionGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkFunctionDefinitionGroupArgs = NetworkFunctionDefinitionGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkFunctionDefinitionGroupArgsBuilder.() -> Unit) {
        val builder = NetworkFunctionDefinitionGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkFunctionDefinitionGroup {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkFunctionDefinitionGroup(builtJavaResource)
    }
}

/**
 * Network function definition group resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update the network function definition group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunctionDefinitionGroup = new AzureNative.HybridNetwork.NetworkFunctionDefinitionGroup("networkFunctionDefinitionGroup", new()
 *     {
 *         Location = "eastus",
 *         NetworkFunctionDefinitionGroupName = "TestNetworkFunctionDefinitionGroupName",
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkFunctionDefinitionGroup(ctx, "networkFunctionDefinitionGroup", &hybridnetwork.NetworkFunctionDefinitionGroupArgs{
 * 			Location:                           pulumi.String("eastus"),
 * 			NetworkFunctionDefinitionGroupName: pulumi.String("TestNetworkFunctionDefinitionGroupName"),
 * 			PublisherName:                      pulumi.String("TestPublisher"),
 * 			ResourceGroupName:                  pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroup;
 * import com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunctionDefinitionGroup = new NetworkFunctionDefinitionGroup("networkFunctionDefinitionGroup", NetworkFunctionDefinitionGroupArgs.builder()
 *             .location("eastus")
 *             .networkFunctionDefinitionGroupName("TestNetworkFunctionDefinitionGroupName")
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkFunctionDefinitionGroup TestPublisherSkuVersion /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/networkFunctionDefinitionGroups/{networkFunctionDefinitionGroupName}
 * ```
 */
public class NetworkFunctionDefinitionGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroup,
) : KotlinCustomResource(javaResource, NetworkFunctionDefinitionGroupMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network function definition group properties.
     */
    public val properties: Output<NetworkFunctionDefinitionGroupPropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                networkFunctionDefinitionGroupPropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkFunctionDefinitionGroupMapper : ResourceMapper<NetworkFunctionDefinitionGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroup::class == javaResource::class

    override fun map(javaResource: Resource): NetworkFunctionDefinitionGroup =
        NetworkFunctionDefinitionGroup(
            javaResource as
                com.pulumi.azurenative.hybridnetwork.NetworkFunctionDefinitionGroup,
        )
}

/**
 * @see [NetworkFunctionDefinitionGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkFunctionDefinitionGroup].
 */
public suspend fun networkFunctionDefinitionGroup(
    name: String,
    block: suspend NetworkFunctionDefinitionGroupResourceBuilder.() -> Unit,
):
    NetworkFunctionDefinitionGroup {
    val builder = NetworkFunctionDefinitionGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkFunctionDefinitionGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkFunctionDefinitionGroup(name: String): NetworkFunctionDefinitionGroup {
    val builder = NetworkFunctionDefinitionGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
