@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignGroupArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkServiceDesignGroupPropertiesFormatArgs
import com.pulumi.azurenative.hybridnetwork.kotlin.inputs.NetworkServiceDesignGroupPropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * network service design group resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update the network service design group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkServiceDesignGroup = new AzureNative.HybridNetwork.NetworkServiceDesignGroup("networkServiceDesignGroup", new()
 *     {
 *         Location = "eastus",
 *         NetworkServiceDesignGroupName = "TestNetworkServiceDesignGroupName",
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewNetworkServiceDesignGroup(ctx, "networkServiceDesignGroup", &hybridnetwork.NetworkServiceDesignGroupArgs{
 * 			Location:                      pulumi.String("eastus"),
 * 			NetworkServiceDesignGroupName: pulumi.String("TestNetworkServiceDesignGroupName"),
 * 			PublisherName:                 pulumi.String("TestPublisher"),
 * 			ResourceGroupName:             pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignGroup;
 * import com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkServiceDesignGroup = new NetworkServiceDesignGroup("networkServiceDesignGroup", NetworkServiceDesignGroupArgs.builder()
 *             .location("eastus")
 *             .networkServiceDesignGroupName("TestNetworkServiceDesignGroupName")
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:NetworkServiceDesignGroup TestNetworkServiceDesignGroupName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}/networkServiceDesignGroups/{networkServiceDesignGroupName}
 * ```
 * @property location The geo-location where the resource lives
 * @property networkServiceDesignGroupName The name of the network service design group.
 * @property properties network service design group properties.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkServiceDesignGroupArgs(
    public val location: Output<String>? = null,
    public val networkServiceDesignGroupName: Output<String>? = null,
    public val properties: Output<NetworkServiceDesignGroupPropertiesFormatArgs>? = null,
    public val publisherName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignGroupArgs =
        com.pulumi.azurenative.hybridnetwork.NetworkServiceDesignGroupArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .networkServiceDesignGroupName(networkServiceDesignGroupName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkServiceDesignGroupArgs].
 */
@PulumiTagMarker
public class NetworkServiceDesignGroupArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var networkServiceDesignGroupName: Output<String>? = null

    private var properties: Output<NetworkServiceDesignGroupPropertiesFormatArgs>? = null

    private var publisherName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ejrqncugdcpufgdj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network service design group.
     */
    @JvmName("ujgjucwsoyfkhxlb")
    public suspend fun networkServiceDesignGroupName(`value`: Output<String>) {
        this.networkServiceDesignGroupName = value
    }

    /**
     * @param value network service design group properties.
     */
    @JvmName("ylpbpqlkttffbmmc")
    public suspend fun properties(`value`: Output<NetworkServiceDesignGroupPropertiesFormatArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("pqlecicjxffvjxlu")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gyhqjejdvgrdajig")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("juhtvvaygeansuly")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cqidyhefqrifpgyu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network service design group.
     */
    @JvmName("ujemqvsxvnxeethh")
    public suspend fun networkServiceDesignGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkServiceDesignGroupName = mapped
    }

    /**
     * @param value network service design group properties.
     */
    @JvmName("siogsnjftqmfutir")
    public suspend fun properties(`value`: NetworkServiceDesignGroupPropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument network service design group properties.
     */
    @JvmName("wnvtrgrfwqncxeqj")
    public suspend
    fun properties(argument: suspend NetworkServiceDesignGroupPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkServiceDesignGroupPropertiesFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("ncqsuwvhxfpjicee")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hgyfscjqwmikuaco")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bvkvavsbqtwlbmst")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ptityqkubrwnqeru")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkServiceDesignGroupArgs = NetworkServiceDesignGroupArgs(
        location = location,
        networkServiceDesignGroupName = networkServiceDesignGroupName,
        properties = properties,
        publisherName = publisherName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
