@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.PublisherPropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.PublisherPropertiesFormatResponse.Companion.toKotlin as publisherPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Publisher].
 */
@PulumiTagMarker
public class PublisherResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PublisherArgs = PublisherArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PublisherArgsBuilder.() -> Unit) {
        val builder = PublisherArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Publisher {
        val builtJavaResource = com.pulumi.azurenative.hybridnetwork.Publisher(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Publisher(builtJavaResource)
    }
}

/**
 * publisher resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create or update a publisher resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publisher = new AzureNative.HybridNetwork.Publisher("publisher", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.HybridNetwork.Inputs.PublisherPropertiesFormatArgs
 *         {
 *             Scope = "Public",
 *         },
 *         PublisherName = "TestPublisher",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hybridnetwork.NewPublisher(ctx, "publisher", &hybridnetwork.PublisherArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: &hybridnetwork.PublisherPropertiesFormatArgs{
 * 				Scope: pulumi.String("Public"),
 * 			},
 * 			PublisherName:     pulumi.String("TestPublisher"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.Publisher;
 * import com.pulumi.azurenative.hybridnetwork.PublisherArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publisher = new Publisher("publisher", PublisherArgs.builder()
 *             .location("eastus")
 *             .properties(Map.of("scope", "Public"))
 *             .publisherName("TestPublisher")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:Publisher TestPublisher /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/publishers/{publisherName}
 * ```
 */
public class Publisher internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.Publisher,
) : KotlinCustomResource(javaResource, PublisherMapper) {
    /**
     * The managed identity of the publisher, if configured.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Publisher properties.
     */
    public val properties: Output<PublisherPropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                publisherPropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PublisherMapper : ResourceMapper<Publisher> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.Publisher::class == javaResource::class

    override fun map(javaResource: Resource): Publisher = Publisher(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.Publisher,
    )
}

/**
 * @see [Publisher].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Publisher].
 */
public suspend fun publisher(name: String, block: suspend PublisherResourceBuilder.() -> Unit):
    Publisher {
    val builder = PublisherResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Publisher].
 * @param name The _unique_ name of the resulting resource.
 */
public fun publisher(name: String): Publisher {
    val builder = PublisherResourceBuilder()
    builder.name(name)
    return builder.build()
}
