@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin

import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SiteNetworkServicePropertiesFormatResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SiteNetworkServicePropertiesFormatResponse.Companion.toKotlin as siteNetworkServicePropertiesFormatResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SiteNetworkService].
 */
@PulumiTagMarker
public class SiteNetworkServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SiteNetworkServiceArgs = SiteNetworkServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SiteNetworkServiceArgsBuilder.() -> Unit) {
        val builder = SiteNetworkServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SiteNetworkService {
        val builtJavaResource =
            com.pulumi.azurenative.hybridnetwork.SiteNetworkService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SiteNetworkService(builtJavaResource)
    }
}

/**
 * Site network service resource.
 * Azure REST API version: 2023-09-01.
 * ## Example Usage
 * ### Create first party site network service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var siteNetworkService = new AzureNative.HybridNetwork.SiteNetworkService("siteNetworkService", new()
 *     {
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.SiteNetworkServicePropertiesFormatArgs
 *         {
 *             DesiredStateConfigurationGroupValueReferences =
 *             {
 *                 { "MyVM_Configuration", new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1",
 *                 } },
 *             },
 *             NetworkServiceDesignVersionResourceReference = new AzureNative.HybridNetwork.Inputs.SecretDeploymentResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 *                 IdType = "Secret",
 *             },
 *             SiteReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteNetworkServiceName = "testSiteNetworkServiceName",
 *         Sku = new AzureNative.HybridNetwork.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hybridnetwork.NewSiteNetworkService(ctx, "siteNetworkService", &hybridnetwork.SiteNetworkServiceArgs{
 * Location: pulumi.String("westUs2"),
 * Properties: interface{}{
 * DesiredStateConfigurationGroupValueReferences: hybridnetwork.ReferencedResourceMap{
 * "MyVM_Configuration": &hybridnetwork.ReferencedResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1"),
 * },
 * },
 * NetworkServiceDesignVersionResourceReference: hybridnetwork.SecretDeploymentResourceReference{
 * Id: "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 * IdType: "Secret",
 * },
 * SiteReference: &hybridnetwork.ReferencedResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * SiteNetworkServiceName: pulumi.String("testSiteNetworkServiceName"),
 * Sku: &hybridnetwork.SkuArgs{
 * Name: pulumi.String("Standard"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkService;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var siteNetworkService = new SiteNetworkService("siteNetworkService", SiteNetworkServiceArgs.builder()
 *             .location("westUs2")
 *             .properties(Map.ofEntries(
 *                 Map.entry("desiredStateConfigurationGroupValueReferences", Map.of("MyVM_Configuration", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1"))),
 *                 Map.entry("networkServiceDesignVersionResourceReference", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0"),
 *                     Map.entry("idType", "Secret")
 *                 )),
 *                 Map.entry("siteReference", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite"))
 *             ))
 *             .resourceGroupName("rg1")
 *             .siteNetworkServiceName("testSiteNetworkServiceName")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create site network service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var siteNetworkService = new AzureNative.HybridNetwork.SiteNetworkService("siteNetworkService", new()
 *     {
 *         Location = "westUs2",
 *         Properties = new AzureNative.HybridNetwork.Inputs.SiteNetworkServicePropertiesFormatArgs
 *         {
 *             DesiredStateConfigurationGroupValueReferences =
 *             {
 *                 { "MyVM_Configuration", new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1",
 *                 } },
 *             },
 *             NetworkServiceDesignVersionResourceReference = new AzureNative.HybridNetwork.Inputs.OpenDeploymentResourceReferenceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 *                 IdType = "Open",
 *             },
 *             SiteReference = new AzureNative.HybridNetwork.Inputs.ReferencedResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteNetworkServiceName = "testSiteNetworkServiceName",
 *         Sku = new AzureNative.HybridNetwork.Inputs.SkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hybridnetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := hybridnetwork.NewSiteNetworkService(ctx, "siteNetworkService", &hybridnetwork.SiteNetworkServiceArgs{
 * Location: pulumi.String("westUs2"),
 * Properties: interface{}{
 * DesiredStateConfigurationGroupValueReferences: hybridnetwork.ReferencedResourceMap{
 * "MyVM_Configuration": &hybridnetwork.ReferencedResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1"),
 * },
 * },
 * NetworkServiceDesignVersionResourceReference: hybridnetwork.OpenDeploymentResourceReference{
 * Id: "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0",
 * IdType: "Open",
 * },
 * SiteReference: &hybridnetwork.ReferencedResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * SiteNetworkServiceName: pulumi.String("testSiteNetworkServiceName"),
 * Sku: &hybridnetwork.SkuArgs{
 * Name: pulumi.String("Standard"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkService;
 * import com.pulumi.azurenative.hybridnetwork.SiteNetworkServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var siteNetworkService = new SiteNetworkService("siteNetworkService", SiteNetworkServiceArgs.builder()
 *             .location("westUs2")
 *             .properties(Map.ofEntries(
 *                 Map.entry("desiredStateConfigurationGroupValueReferences", Map.of("MyVM_Configuration", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/configurationgroupvalues/MyVM_Configuration1"))),
 *                 Map.entry("networkServiceDesignVersionResourceReference", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourcegroups/rg/providers/Microsoft.HybridNetwork/publishers/TestPublisher/networkServiceDesignGroups/TestNetworkServiceDesignGroupName/networkServiceDesignVersions/1.0.0"),
 *                     Map.entry("idType", "Open")
 *                 )),
 *                 Map.entry("siteReference", Map.of("id", "/subscriptions/subid/resourcegroups/contosorg1/providers/microsoft.hybridnetwork/sites/testSite"))
 *             ))
 *             .resourceGroupName("rg1")
 *             .siteNetworkServiceName("testSiteNetworkServiceName")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hybridnetwork:SiteNetworkService testSiteNetworkServiceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridNetwork/siteNetworkServices/{siteNetworkServiceName}
 * ```
 */
public class SiteNetworkService internal constructor(
    override val javaResource: com.pulumi.azurenative.hybridnetwork.SiteNetworkService,
) : KotlinCustomResource(javaResource, SiteNetworkServiceMapper) {
    /**
     * The managed identity of the Site network service, if configured.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Site network service properties.
     */
    public val properties: Output<SiteNetworkServicePropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                siteNetworkServicePropertiesFormatResponseToKotlin(args0)
            })
        })

    /**
     * Sku of the site network service.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SiteNetworkServiceMapper : ResourceMapper<SiteNetworkService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hybridnetwork.SiteNetworkService::class == javaResource::class

    override fun map(javaResource: Resource): SiteNetworkService = SiteNetworkService(
        javaResource as
            com.pulumi.azurenative.hybridnetwork.SiteNetworkService,
    )
}

/**
 * @see [SiteNetworkService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SiteNetworkService].
 */
public suspend fun siteNetworkService(
    name: String,
    block: suspend SiteNetworkServiceResourceBuilder.() -> Unit,
): SiteNetworkService {
    val builder = SiteNetworkServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SiteNetworkService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun siteNetworkService(name: String): SiteNetworkService {
    val builder = SiteNetworkServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
