@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureArcK8sClusterNFVIDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The AzureArcK8sCluster NFVI detail.
 * @property customLocationReference The reference to the custom location.
 * @property name Name of the nfvi.
 * @property nfviType The NFVI type.
 * Expected value is 'AzureArcKubernetes'.
 */
public data class AzureArcK8sClusterNFVIDetailsArgs(
    public val customLocationReference: Output<ReferencedResourceArgs>? = null,
    public val name: Output<String>? = null,
    public val nfviType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureArcK8sClusterNFVIDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcK8sClusterNFVIDetailsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcK8sClusterNFVIDetailsArgs.builder()
            .customLocationReference(
                customLocationReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .nfviType(nfviType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureArcK8sClusterNFVIDetailsArgs].
 */
@PulumiTagMarker
public class AzureArcK8sClusterNFVIDetailsArgsBuilder internal constructor() {
    private var customLocationReference: Output<ReferencedResourceArgs>? = null

    private var name: Output<String>? = null

    private var nfviType: Output<String>? = null

    /**
     * @param value The reference to the custom location.
     */
    @JvmName("umemtqdptlmidjqi")
    public suspend fun customLocationReference(`value`: Output<ReferencedResourceArgs>) {
        this.customLocationReference = value
    }

    /**
     * @param value Name of the nfvi.
     */
    @JvmName("ratqlrybiqfjubhr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The NFVI type.
     * Expected value is 'AzureArcKubernetes'.
     */
    @JvmName("qqkbfxkunqrdhrsu")
    public suspend fun nfviType(`value`: Output<String>) {
        this.nfviType = value
    }

    /**
     * @param value The reference to the custom location.
     */
    @JvmName("ucuxfvvhepgecjwu")
    public suspend fun customLocationReference(`value`: ReferencedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLocationReference = mapped
    }

    /**
     * @param argument The reference to the custom location.
     */
    @JvmName("qjrifajagvgvjxul")
    public suspend
    fun customLocationReference(argument: suspend ReferencedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ReferencedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customLocationReference = mapped
    }

    /**
     * @param value Name of the nfvi.
     */
    @JvmName("ewhqkinqhmehmcbj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The NFVI type.
     * Expected value is 'AzureArcKubernetes'.
     */
    @JvmName("vffgwcdjmfrbwokk")
    public suspend fun nfviType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfviType = mapped
    }

    internal fun build(): AzureArcK8sClusterNFVIDetailsArgs = AzureArcK8sClusterNFVIDetailsArgs(
        customLocationReference = customLocationReference,
        name = name,
        nfviType = nfviType ?: throw PulumiNullFieldException("nfviType"),
    )
}
