@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesHelmApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure arc kubernetes helm application configurations.
 * @property artifactProfile Azure arc kubernetes artifact profile.
 * @property artifactType The artifact type.
 * Expected value is 'HelmPackage'.
 * @property dependsOnProfile Depends on profile definition.
 * @property deployParametersMappingRuleProfile Deploy mapping rule profile.
 * @property name The name of the network function application.
 */
public data class AzureArcKubernetesHelmApplicationArgs(
    public val artifactProfile: Output<AzureArcKubernetesArtifactProfileArgs>? = null,
    public val artifactType: Output<String>,
    public val dependsOnProfile: Output<DependsOnProfileArgs>? = null,
    public val deployParametersMappingRuleProfile:
    Output<AzureArcKubernetesDeployMappingRuleProfileArgs>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesHelmApplicationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesHelmApplicationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureArcKubernetesHelmApplicationArgs.builder()
            .artifactProfile(artifactProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .artifactType(artifactType.applyValue({ args0 -> args0 }))
            .dependsOnProfile(dependsOnProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deployParametersMappingRuleProfile(
                deployParametersMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureArcKubernetesHelmApplicationArgs].
 */
@PulumiTagMarker
public class AzureArcKubernetesHelmApplicationArgsBuilder internal constructor() {
    private var artifactProfile: Output<AzureArcKubernetesArtifactProfileArgs>? = null

    private var artifactType: Output<String>? = null

    private var dependsOnProfile: Output<DependsOnProfileArgs>? = null

    private var deployParametersMappingRuleProfile:
        Output<AzureArcKubernetesDeployMappingRuleProfileArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Azure arc kubernetes artifact profile.
     */
    @JvmName("koehnmfmxfbsmxnp")
    public suspend fun artifactProfile(`value`: Output<AzureArcKubernetesArtifactProfileArgs>) {
        this.artifactProfile = value
    }

    /**
     * @param value The artifact type.
     * Expected value is 'HelmPackage'.
     */
    @JvmName("omrjfloqcmjyqikc")
    public suspend fun artifactType(`value`: Output<String>) {
        this.artifactType = value
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("jmrpbsyruwnksrsd")
    public suspend fun dependsOnProfile(`value`: Output<DependsOnProfileArgs>) {
        this.dependsOnProfile = value
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("lrtfmlvyjnyhqjqs")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: Output<AzureArcKubernetesDeployMappingRuleProfileArgs>) {
        this.deployParametersMappingRuleProfile = value
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("xbdcvxmctvfbncbp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure arc kubernetes artifact profile.
     */
    @JvmName("foaejgmypjqhdwve")
    public suspend fun artifactProfile(`value`: AzureArcKubernetesArtifactProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactProfile = mapped
    }

    /**
     * @param argument Azure arc kubernetes artifact profile.
     */
    @JvmName("tpmyjfjyuynyijvy")
    public suspend
    fun artifactProfile(argument: suspend AzureArcKubernetesArtifactProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureArcKubernetesArtifactProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.artifactProfile = mapped
    }

    /**
     * @param value The artifact type.
     * Expected value is 'HelmPackage'.
     */
    @JvmName("mtfgsaqbihhntsid")
    public suspend fun artifactType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactType = mapped
    }

    /**
     * @param value Depends on profile definition.
     */
    @JvmName("qkuctafrcuvsasgx")
    public suspend fun dependsOnProfile(`value`: DependsOnProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnProfile = mapped
    }

    /**
     * @param argument Depends on profile definition.
     */
    @JvmName("vsdimadcuurpaokn")
    public suspend fun dependsOnProfile(argument: suspend DependsOnProfileArgsBuilder.() -> Unit) {
        val toBeMapped = DependsOnProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dependsOnProfile = mapped
    }

    /**
     * @param value Deploy mapping rule profile.
     */
    @JvmName("hgiwiqfwwjkeaeuy")
    public suspend
    fun deployParametersMappingRuleProfile(`value`: AzureArcKubernetesDeployMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param argument Deploy mapping rule profile.
     */
    @JvmName("etjnjteokswmftxs")
    public suspend
    fun deployParametersMappingRuleProfile(argument: suspend AzureArcKubernetesDeployMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AzureArcKubernetesDeployMappingRuleProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deployParametersMappingRuleProfile = mapped
    }

    /**
     * @param value The name of the network function application.
     */
    @JvmName("ortikfstyevvndfd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureArcKubernetesHelmApplicationArgs =
        AzureArcKubernetesHelmApplicationArgs(
            artifactProfile = artifactProfile,
            artifactType = artifactType ?: throw PulumiNullFieldException("artifactType"),
            dependsOnProfile = dependsOnProfile,
            deployParametersMappingRuleProfile = deployParametersMappingRuleProfile,
            name = name,
        )
}
