@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNFVIDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Azure Core NFVI detail.
 * @property location Location of the Azure core.
 * @property name Name of the nfvi.
 * @property nfviType The NFVI type.
 * Expected value is 'AzureCore'.
 */
public data class AzureCoreNFVIDetailsArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nfviType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNFVIDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNFVIDetailsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureCoreNFVIDetailsArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nfviType(nfviType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureCoreNFVIDetailsArgs].
 */
@PulumiTagMarker
public class AzureCoreNFVIDetailsArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var nfviType: Output<String>? = null

    /**
     * @param value Location of the Azure core.
     */
    @JvmName("txvgkxtwvdtqmnte")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the nfvi.
     */
    @JvmName("xryxlllqvomafqdk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The NFVI type.
     * Expected value is 'AzureCore'.
     */
    @JvmName("abhvytqdlugxtofo")
    public suspend fun nfviType(`value`: Output<String>) {
        this.nfviType = value
    }

    /**
     * @param value Location of the Azure core.
     */
    @JvmName("mtmwqiigcgqytyvi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the nfvi.
     */
    @JvmName("wpmfcpshijykjgjm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The NFVI type.
     * Expected value is 'AzureCore'.
     */
    @JvmName("fnefbawnyoceyalf")
    public suspend fun nfviType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfviType = mapped
    }

    internal fun build(): AzureCoreNFVIDetailsArgs = AzureCoreNFVIDetailsArgs(
        location = location,
        name = name,
        nfviType = nfviType ?: throw PulumiNullFieldException("nfviType"),
    )
}
