@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageDeployMappingRuleProfileArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.ApplicationEnablement
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Operator Distributed Services image deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property imageMappingRuleProfile The vhd mapping rule profile.
 */
public data class AzureOperatorNexusImageDeployMappingRuleProfileArgs(
    public val applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null,
    public val imageMappingRuleProfile: Output<ImageMappingRuleProfileArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageDeployMappingRuleProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageDeployMappingRuleProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.AzureOperatorNexusImageDeployMappingRuleProfileArgs.builder()
            .applicationEnablement(
                applicationEnablement?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .imageMappingRuleProfile(
                imageMappingRuleProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureOperatorNexusImageDeployMappingRuleProfileArgs].
 */
@PulumiTagMarker
public class AzureOperatorNexusImageDeployMappingRuleProfileArgsBuilder internal constructor() {
    private var applicationEnablement: Output<Either<String, ApplicationEnablement>>? = null

    private var imageMappingRuleProfile: Output<ImageMappingRuleProfileArgs>? = null

    /**
     * @param value The application enablement.
     */
    @JvmName("ngglhnlqlvkubnii")
    public suspend fun applicationEnablement(`value`: Output<Either<String, ApplicationEnablement>>) {
        this.applicationEnablement = value
    }

    /**
     * @param value The vhd mapping rule profile.
     */
    @JvmName("aqmnnkktbqvwuols")
    public suspend fun imageMappingRuleProfile(`value`: Output<ImageMappingRuleProfileArgs>) {
        this.imageMappingRuleProfile = value
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("jaqcmnkflbjuncdw")
    public suspend fun applicationEnablement(`value`: Either<String, ApplicationEnablement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("ruwjlhccmljkitpq")
    public fun applicationEnablement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The application enablement.
     */
    @JvmName("rpjfgssxvftwqstw")
    public fun applicationEnablement(`value`: ApplicationEnablement) {
        val toBeMapped = Either.ofRight<String, ApplicationEnablement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationEnablement = mapped
    }

    /**
     * @param value The vhd mapping rule profile.
     */
    @JvmName("vokuvdfcimeenoyv")
    public suspend fun imageMappingRuleProfile(`value`: ImageMappingRuleProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageMappingRuleProfile = mapped
    }

    /**
     * @param argument The vhd mapping rule profile.
     */
    @JvmName("twrgphguswsujkxf")
    public suspend
    fun imageMappingRuleProfile(argument: suspend ImageMappingRuleProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ImageMappingRuleProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageMappingRuleProfile = mapped
    }

    internal fun build(): AzureOperatorNexusImageDeployMappingRuleProfileArgs =
        AzureOperatorNexusImageDeployMappingRuleProfileArgs(
            applicationEnablement = applicationEnablement,
            imageMappingRuleProfile = imageMappingRuleProfile,
        )
}
