@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithoutSecretsArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ConfigurationValue with no secrets.
 * @property configurationGroupSchemaResourceReference The configuration group schema resource reference.
 * @property configurationType The secret type which indicates if secret or not.
 * Expected value is 'Open'.
 * @property configurationValue Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
 */
public data class ConfigurationValueWithoutSecretsArgs(
    public val configurationGroupSchemaResourceReference:
    Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>? =
        null,
    public val configurationType: Output<String>,
    public val configurationValue: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithoutSecretsArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithoutSecretsArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ConfigurationValueWithoutSecretsArgs.builder()
            .configurationGroupSchemaResourceReference(
                configurationGroupSchemaResourceReference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .configurationValue(configurationValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationValueWithoutSecretsArgs].
 */
@PulumiTagMarker
public class ConfigurationValueWithoutSecretsArgsBuilder internal constructor() {
    private var configurationGroupSchemaResourceReference:
        Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>? =
        null

    private var configurationType: Output<String>? = null

    private var configurationValue: Output<String>? = null

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("kceqphgkothsoltg")
    public suspend
    fun configurationGroupSchemaResourceReference(`value`: Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>) {
        this.configurationGroupSchemaResourceReference = value
    }

    /**
     * @param value The secret type which indicates if secret or not.
     * Expected value is 'Open'.
     */
    @JvmName("lbydhmyohikwdabf")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
     */
    @JvmName("kddudpmvcvydhgwc")
    public suspend fun configurationValue(`value`: Output<String>) {
        this.configurationValue = value
    }

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("rlyeucygqoegxthu")
    public suspend
    fun configurationGroupSchemaResourceReference(`value`: Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationGroupSchemaResourceReference = mapped
    }

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("elthflqkxpjlctmf")
    public
    fun configurationGroupSchemaResourceReference(`value`: OpenDeploymentResourceReferenceArgs) {
        val toBeMapped = Either.ofLeft<OpenDeploymentResourceReferenceArgs,
            SecretDeploymentResourceReferenceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationGroupSchemaResourceReference = mapped
    }

    /**
     * @param value The configuration group schema resource reference.
     */
    @JvmName("avyhnrfroenexhdr")
    public
    fun configurationGroupSchemaResourceReference(`value`: SecretDeploymentResourceReferenceArgs) {
        val toBeMapped = Either.ofRight<OpenDeploymentResourceReferenceArgs,
            SecretDeploymentResourceReferenceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationGroupSchemaResourceReference = mapped
    }

    /**
     * @param value The secret type which indicates if secret or not.
     * Expected value is 'Open'.
     */
    @JvmName("npwbvieqqcfwpuyh")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
     */
    @JvmName("inyjmpteaduktvau")
    public suspend fun configurationValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationValue = mapped
    }

    internal fun build(): ConfigurationValueWithoutSecretsArgs = ConfigurationValueWithoutSecretsArgs(
        configurationGroupSchemaResourceReference = configurationGroupSchemaResourceReference,
        configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
        configurationValue = configurationValue,
    )
}
