@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.CustomProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the custom settings for the virtual machine.
 * @property metadataConfigurationPath Path for metadata configuration.
 */
public data class CustomProfileArgs(
    public val metadataConfigurationPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.CustomProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.CustomProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.CustomProfileArgs.builder()
            .metadataConfigurationPath(metadataConfigurationPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomProfileArgs].
 */
@PulumiTagMarker
public class CustomProfileArgsBuilder internal constructor() {
    private var metadataConfigurationPath: Output<String>? = null

    /**
     * @param value Path for metadata configuration.
     */
    @JvmName("echbymackhydsjrw")
    public suspend fun metadataConfigurationPath(`value`: Output<String>) {
        this.metadataConfigurationPath = value
    }

    /**
     * @param value Path for metadata configuration.
     */
    @JvmName("wygsxrupblalvbvx")
    public suspend fun metadataConfigurationPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataConfigurationPath = mapped
    }

    internal fun build(): CustomProfileArgs = CustomProfileArgs(
        metadataConfigurationPath = metadataConfigurationPath,
    )
}
