@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkFunctionDefinitionGroupName The name of the network function definition group.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkFunctionDefinitionGroupPlainArgs(
    public val networkFunctionDefinitionGroupName: String,
    public val publisherName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionGroupPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionGroupPlainArgs.builder()
            .networkFunctionDefinitionGroupName(networkFunctionDefinitionGroupName.let({ args0 -> args0 }))
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkFunctionDefinitionGroupPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkFunctionDefinitionGroupPlainArgsBuilder internal constructor() {
    private var networkFunctionDefinitionGroupName: String? = null

    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network function definition group.
     */
    @JvmName("uptieplhcnktrnfj")
    public suspend fun networkFunctionDefinitionGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFunctionDefinitionGroupName = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("xdaaaiphqxkefklt")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("crufviuedkhmqftu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkFunctionDefinitionGroupPlainArgs =
        GetNetworkFunctionDefinitionGroupPlainArgs(
            networkFunctionDefinitionGroupName = networkFunctionDefinitionGroupName ?: throw
                PulumiNullFieldException("networkFunctionDefinitionGroupName"),
            publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
