@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkFunctionDefinitionGroupName The name of the network function definition group.
 * @property networkFunctionDefinitionVersionName The name of the network function definition version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
 * @property publisherName The name of the publisher.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkFunctionDefinitionVersionPlainArgs(
    public val networkFunctionDefinitionGroupName: String,
    public val networkFunctionDefinitionVersionName: String,
    public val publisherName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionVersionPlainArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.GetNetworkFunctionDefinitionVersionPlainArgs.builder()
            .networkFunctionDefinitionGroupName(networkFunctionDefinitionGroupName.let({ args0 -> args0 }))
            .networkFunctionDefinitionVersionName(networkFunctionDefinitionVersionName.let({ args0 -> args0 }))
            .publisherName(publisherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkFunctionDefinitionVersionPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkFunctionDefinitionVersionPlainArgsBuilder internal constructor() {
    private var networkFunctionDefinitionGroupName: String? = null

    private var networkFunctionDefinitionVersionName: String? = null

    private var publisherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network function definition group.
     */
    @JvmName("xtdsufsfrlrjckgo")
    public suspend fun networkFunctionDefinitionGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFunctionDefinitionGroupName = mapped
    }

    /**
     * @param value The name of the network function definition version. The name should conform to the SemVer 2.0.0 specification: https://semver.org/spec/v2.0.0.html.
     */
    @JvmName("xnfxthutrbjugiib")
    public suspend fun networkFunctionDefinitionVersionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFunctionDefinitionVersionName = mapped
    }

    /**
     * @param value The name of the publisher.
     */
    @JvmName("jevswtyflwwqehnc")
    public suspend fun publisherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publisherName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("peeboavvvphwpkog")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkFunctionDefinitionVersionPlainArgs =
        GetNetworkFunctionDefinitionVersionPlainArgs(
            networkFunctionDefinitionGroupName = networkFunctionDefinitionGroupName ?: throw
                PulumiNullFieldException("networkFunctionDefinitionGroupName"),
            networkFunctionDefinitionVersionName = networkFunctionDefinitionVersionName ?: throw
                PulumiNullFieldException("networkFunctionDefinitionVersionName"),
            publisherName = publisherName ?: throw PulumiNullFieldException("publisherName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
