@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceIPConfigurationArgs.builder
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.IPAllocationMethod
import com.pulumi.azurenative.hybridnetwork.kotlin.enums.IPVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network interface IP configuration properties.
 * @property dnsServers The list of DNS servers IP addresses.
 * @property gateway The value of the gateway.
 * @property ipAddress The value of the IP address.
 * @property ipAllocationMethod IP address allocation method.
 * @property ipVersion IP address version.
 * @property subnet The value of the subnet.
 */
public data class NetworkInterfaceIPConfigurationArgs(
    public val dnsServers: Output<List<String>>? = null,
    public val gateway: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val ipAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val ipVersion: Output<Either<String, IPVersion>>? = null,
    public val subnet: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceIPConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceIPConfigurationArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkInterfaceIPConfigurationArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gateway(gateway?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .ipAllocationMethod(
                ipAllocationMethod?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipVersion(
                ipVersion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceIPConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceIPConfigurationArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    private var gateway: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var ipAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var ipVersion: Output<Either<String, IPVersion>>? = null

    private var subnet: Output<String>? = null

    /**
     * @param value The list of DNS servers IP addresses.
     */
    @JvmName("bjhbbtvugvdvgsej")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("skctiivmvuytdlgk")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values The list of DNS servers IP addresses.
     */
    @JvmName("uepkllildvsonwyk")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value The value of the gateway.
     */
    @JvmName("xvlrtqdbkahtfaej")
    public suspend fun gateway(`value`: Output<String>) {
        this.gateway = value
    }

    /**
     * @param value The value of the IP address.
     */
    @JvmName("oueicqypkclaflml")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value IP address allocation method.
     */
    @JvmName("qsmixaxunbaqbtyh")
    public suspend fun ipAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.ipAllocationMethod = value
    }

    /**
     * @param value IP address version.
     */
    @JvmName("wxjwcwhjpfsghbce")
    public suspend fun ipVersion(`value`: Output<Either<String, IPVersion>>) {
        this.ipVersion = value
    }

    /**
     * @param value The value of the subnet.
     */
    @JvmName("akwaelqefsqrseij")
    public suspend fun subnet(`value`: Output<String>) {
        this.subnet = value
    }

    /**
     * @param value The list of DNS servers IP addresses.
     */
    @JvmName("pwmgryqfucrvvobr")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values The list of DNS servers IP addresses.
     */
    @JvmName("lsvefafgvlfmviog")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value The value of the gateway.
     */
    @JvmName("jkmwutgljfgolpyp")
    public suspend fun gateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gateway = mapped
    }

    /**
     * @param value The value of the IP address.
     */
    @JvmName("avheqbpibnfcpkwk")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value IP address allocation method.
     */
    @JvmName("tuhrrehlakecllyn")
    public suspend fun ipAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IP address allocation method.
     */
    @JvmName("xpyxoeibhaglaoac")
    public fun ipAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IP address allocation method.
     */
    @JvmName("vhysjswqscpmwodx")
    public fun ipAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IP address version.
     */
    @JvmName("pxhrfxcyneuetdeb")
    public suspend fun ipVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value IP address version.
     */
    @JvmName("dllearftadwjhbwg")
    public fun ipVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value IP address version.
     */
    @JvmName("hjqrvgknyyrciqwd")
    public fun ipVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipVersion = mapped
    }

    /**
     * @param value The value of the subnet.
     */
    @JvmName("ktyetxxucvdptemj")
    public suspend fun subnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    internal fun build(): NetworkInterfaceIPConfigurationArgs = NetworkInterfaceIPConfigurationArgs(
        dnsServers = dnsServers,
        gateway = gateway,
        ipAddress = ipAddress,
        ipAllocationMethod = ipAllocationMethod,
        ipVersion = ipVersion,
        subnet = subnet,
    )
}
