@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignVersionPropertiesFormatArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * network service design version properties.
 * @property configurationGroupSchemaReferences The configuration schemas to used to define the values.
 * @property description The network service design version description.
 * @property nfvisFromSite The nfvis from the site.
 * @property resourceElementTemplates List of resource element template
 */
public data class NetworkServiceDesignVersionPropertiesFormatArgs(
    public val configurationGroupSchemaReferences: Output<Map<String, ReferencedResourceArgs>>? =
        null,
    public val description: Output<String>? = null,
    public val nfvisFromSite: Output<Map<String, NfviDetailsArgs>>? = null,
    public val resourceElementTemplates:
    Output<List<Either<ArmResourceDefinitionResourceElementTemplateDetailsArgs, NetworkFunctionDefinitionResourceElementTemplateDetailsArgs>>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignVersionPropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignVersionPropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkServiceDesignVersionPropertiesFormatArgs.builder()
            .configurationGroupSchemaReferences(
                configurationGroupSchemaReferences?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value.let({ args0 -> args0.toJava() })) }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .nfvisFromSite(
                nfvisFromSite?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceElementTemplates(
                resourceElementTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkServiceDesignVersionPropertiesFormatArgs].
 */
@PulumiTagMarker
public class NetworkServiceDesignVersionPropertiesFormatArgsBuilder internal constructor() {
    private var configurationGroupSchemaReferences: Output<Map<String, ReferencedResourceArgs>>? =
        null

    private var description: Output<String>? = null

    private var nfvisFromSite: Output<Map<String, NfviDetailsArgs>>? = null

    private var resourceElementTemplates:
        Output<List<Either<ArmResourceDefinitionResourceElementTemplateDetailsArgs, NetworkFunctionDefinitionResourceElementTemplateDetailsArgs>>>? =
        null

    /**
     * @param value The configuration schemas to used to define the values.
     */
    @JvmName("kcovmdrwndilspna")
    public suspend
    fun configurationGroupSchemaReferences(`value`: Output<Map<String, ReferencedResourceArgs>>) {
        this.configurationGroupSchemaReferences = value
    }

    /**
     * @param value The network service design version description.
     */
    @JvmName("pmlbtwacsmpbeufx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The nfvis from the site.
     */
    @JvmName("llunhpctmxietolk")
    public suspend fun nfvisFromSite(`value`: Output<Map<String, NfviDetailsArgs>>) {
        this.nfvisFromSite = value
    }

    /**
     * @param value List of resource element template
     */
    @JvmName("qvjqtgvlbbatawjy")
    public suspend
    fun resourceElementTemplates(`value`: Output<List<Either<ArmResourceDefinitionResourceElementTemplateDetailsArgs, NetworkFunctionDefinitionResourceElementTemplateDetailsArgs>>>) {
        this.resourceElementTemplates = value
    }

    @JvmName("fyjrfufxwcgixejf")
    public suspend fun resourceElementTemplates(
        vararg
        values: Output<Either<ArmResourceDefinitionResourceElementTemplateDetailsArgs, NetworkFunctionDefinitionResourceElementTemplateDetailsArgs>>,
    ) {
        this.resourceElementTemplates = Output.all(values.asList())
    }

    /**
     * @param values List of resource element template
     */
    @JvmName("eufyynxgdjdjkevc")
    public suspend
    fun resourceElementTemplates(values: List<Output<Either<ArmResourceDefinitionResourceElementTemplateDetailsArgs, NetworkFunctionDefinitionResourceElementTemplateDetailsArgs>>>) {
        this.resourceElementTemplates = Output.all(values)
    }

    /**
     * @param value The configuration schemas to used to define the values.
     */
    @JvmName("krrxpyplxkvdkovy")
    public suspend
    fun configurationGroupSchemaReferences(`value`: Map<String, ReferencedResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationGroupSchemaReferences = mapped
    }

    /**
     * @param argument The configuration schemas to used to define the values.
     */
    @JvmName("tijopnrnwuexonma")
    public suspend fun configurationGroupSchemaReferences(
        vararg
        argument: Pair<String, suspend ReferencedResourceArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ReferencedResourceArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.configurationGroupSchemaReferences = mapped
    }

    /**
     * @param values The configuration schemas to used to define the values.
     */
    @JvmName("jbncynuvgpdvweox")
    public fun configurationGroupSchemaReferences(
        vararg
        values: Pair<String, ReferencedResourceArgs>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationGroupSchemaReferences = mapped
    }

    /**
     * @param value The network service design version description.
     */
    @JvmName("liseadftqxkrwhbl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The nfvis from the site.
     */
    @JvmName("tnxmunumhxccafql")
    public suspend fun nfvisFromSite(`value`: Map<String, NfviDetailsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfvisFromSite = mapped
    }

    /**
     * @param argument The nfvis from the site.
     */
    @JvmName("cxhiuitalodjwhmm")
    public suspend fun nfvisFromSite(
        vararg
        argument: Pair<String, suspend NfviDetailsArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                NfviDetailsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.nfvisFromSite = mapped
    }

    /**
     * @param values The nfvis from the site.
     */
    @JvmName("bsvjydohqewyaqop")
    public fun nfvisFromSite(vararg values: Pair<String, NfviDetailsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfvisFromSite = mapped
    }

    /**
     * @param value List of resource element template
     */
    @JvmName("jjldwyjesbrnooou")
    public suspend
    fun resourceElementTemplates(`value`: List<Either<ArmResourceDefinitionResourceElementTemplateDetailsArgs, NetworkFunctionDefinitionResourceElementTemplateDetailsArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceElementTemplates = mapped
    }

    /**
     * @param values List of resource element template
     */
    @JvmName("qgecnjtgxbygqbjn")
    public suspend fun resourceElementTemplates(
        vararg
        values: Either<ArmResourceDefinitionResourceElementTemplateDetailsArgs, NetworkFunctionDefinitionResourceElementTemplateDetailsArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceElementTemplates = mapped
    }

    internal fun build(): NetworkServiceDesignVersionPropertiesFormatArgs =
        NetworkServiceDesignVersionPropertiesFormatArgs(
            configurationGroupSchemaReferences = configurationGroupSchemaReferences,
            description = description,
            nfvisFromSite = nfvisFromSite,
            resourceElementTemplates = resourceElementTemplates,
        )
}
