@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ReferencedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to another resource.
 * @property id Resource ID.
 */
public data class ReferencedResourceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ReferencedResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ReferencedResourceArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ReferencedResourceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReferencedResourceArgs].
 */
@PulumiTagMarker
public class ReferencedResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ohrypwoxklpjmdps")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ervcmrgacdlpqohi")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ReferencedResourceArgs = ReferencedResourceArgs(
        id = id,
    )
}
