@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.SiteNetworkServicePropertiesFormatArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Site network service properties.
 * @property desiredStateConfigurationGroupValueReferences The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service.
 * @property managedResourceGroupConfiguration Managed resource group configuration.
 * @property networkServiceDesignVersionResourceReference The network service design version resource reference.
 * @property siteReference The site details
 */
public data class SiteNetworkServicePropertiesFormatArgs(
    public val desiredStateConfigurationGroupValueReferences:
    Output<Map<String, ReferencedResourceArgs>>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null,
    public val networkServiceDesignVersionResourceReference:
    Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>? =
        null,
    public val siteReference: Output<ReferencedResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.SiteNetworkServicePropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.SiteNetworkServicePropertiesFormatArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.SiteNetworkServicePropertiesFormatArgs.builder()
            .desiredStateConfigurationGroupValueReferences(
                desiredStateConfigurationGroupValueReferences?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value.let({ args0 -> args0.toJava() })) }).toMap()
                }),
            )
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .networkServiceDesignVersionResourceReference(
                networkServiceDesignVersionResourceReference?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .siteReference(siteReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SiteNetworkServicePropertiesFormatArgs].
 */
@PulumiTagMarker
public class SiteNetworkServicePropertiesFormatArgsBuilder internal constructor() {
    private var desiredStateConfigurationGroupValueReferences:
        Output<Map<String, ReferencedResourceArgs>>? = null

    private var managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null

    private var networkServiceDesignVersionResourceReference:
        Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>? =
        null

    private var siteReference: Output<ReferencedResourceArgs>? = null

    /**
     * @param value The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service.
     */
    @JvmName("kvmuvbxtscotinuf")
    public suspend
    fun desiredStateConfigurationGroupValueReferences(`value`: Output<Map<String, ReferencedResourceArgs>>) {
        this.desiredStateConfigurationGroupValueReferences = value
    }

    /**
     * @param value Managed resource group configuration.
     */
    @JvmName("wsljhodkodsjlyaw")
    public suspend
    fun managedResourceGroupConfiguration(`value`: Output<ManagedResourceGroupConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value The network service design version resource reference.
     */
    @JvmName("ncgyegpothscrnkf")
    public suspend
    fun networkServiceDesignVersionResourceReference(`value`: Output<Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>>) {
        this.networkServiceDesignVersionResourceReference = value
    }

    /**
     * @param value The site details
     */
    @JvmName("ohpeqcamhpstpqds")
    public suspend fun siteReference(`value`: Output<ReferencedResourceArgs>) {
        this.siteReference = value
    }

    /**
     * @param value The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service.
     */
    @JvmName("khcdicbxramosxrv")
    public suspend
    fun desiredStateConfigurationGroupValueReferences(`value`: Map<String, ReferencedResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredStateConfigurationGroupValueReferences = mapped
    }

    /**
     * @param argument The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service.
     */
    @JvmName("ioxocrgfmsmroiuh")
    public suspend fun desiredStateConfigurationGroupValueReferences(
        vararg
        argument: Pair<String, suspend ReferencedResourceArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ReferencedResourceArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.desiredStateConfigurationGroupValueReferences = mapped
    }

    /**
     * @param values The goal state of the site network service resource. This has references to the configuration group value objects that describe the desired state of the site network service.
     */
    @JvmName("buxqqvkpkfjsxacb")
    public fun desiredStateConfigurationGroupValueReferences(
        vararg
        values: Pair<String, ReferencedResourceArgs>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredStateConfigurationGroupValueReferences = mapped
    }

    /**
     * @param value Managed resource group configuration.
     */
    @JvmName("nknpnfyexkmvkqjq")
    public suspend
    fun managedResourceGroupConfiguration(`value`: ManagedResourceGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument Managed resource group configuration.
     */
    @JvmName("eewaxhxsuuwtslnx")
    public suspend
    fun managedResourceGroupConfiguration(argument: suspend ManagedResourceGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedResourceGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value The network service design version resource reference.
     */
    @JvmName("tvbdjbjdyjrbuvew")
    public suspend
    fun networkServiceDesignVersionResourceReference(`value`: Either<OpenDeploymentResourceReferenceArgs, SecretDeploymentResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkServiceDesignVersionResourceReference = mapped
    }

    /**
     * @param value The network service design version resource reference.
     */
    @JvmName("qbvohmqpstdactxb")
    public
    fun networkServiceDesignVersionResourceReference(`value`: OpenDeploymentResourceReferenceArgs) {
        val toBeMapped = Either.ofLeft<OpenDeploymentResourceReferenceArgs,
            SecretDeploymentResourceReferenceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkServiceDesignVersionResourceReference = mapped
    }

    /**
     * @param value The network service design version resource reference.
     */
    @JvmName("diovpmmbchtnxsxp")
    public
    fun networkServiceDesignVersionResourceReference(`value`: SecretDeploymentResourceReferenceArgs) {
        val toBeMapped = Either.ofRight<OpenDeploymentResourceReferenceArgs,
            SecretDeploymentResourceReferenceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkServiceDesignVersionResourceReference = mapped
    }

    /**
     * @param value The site details
     */
    @JvmName("kejlpahqmnqbkdxw")
    public suspend fun siteReference(`value`: ReferencedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteReference = mapped
    }

    /**
     * @param argument The site details
     */
    @JvmName("pilfigrqvsmjsvxo")
    public suspend fun siteReference(argument: suspend ReferencedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ReferencedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.siteReference = mapped
    }

    internal fun build(): SiteNetworkServicePropertiesFormatArgs =
        SiteNetworkServicePropertiesFormatArgs(
            desiredStateConfigurationGroupValueReferences = desiredStateConfigurationGroupValueReferences,
            managedResourceGroupConfiguration = managedResourceGroupConfiguration,
            networkServiceDesignVersionResourceReference = networkServiceDesignVersionResourceReference,
            siteReference = siteReference,
        )
}
