@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.StorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the storage settings for the virtual machine disks.
 * @property dataDisks Specifies the parameters that are used to add a data disk to a virtual machine.
 * @property imageReference The image reference properties.
 * @property osDisk Specifies information about the operating system disk used by the virtual machine.
 */
public data class StorageProfileArgs(
    public val dataDisks: Output<List<DataDiskArgs>>? = null,
    public val imageReference: Output<ImageReferenceArgs>? = null,
    public val osDisk: Output<OsDiskArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.StorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.StorageProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.StorageProfileArgs.builder()
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageReference(imageReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osDisk(osDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [StorageProfileArgs].
 */
@PulumiTagMarker
public class StorageProfileArgsBuilder internal constructor() {
    private var dataDisks: Output<List<DataDiskArgs>>? = null

    private var imageReference: Output<ImageReferenceArgs>? = null

    private var osDisk: Output<OsDiskArgs>? = null

    /**
     * @param value Specifies the parameters that are used to add a data disk to a virtual machine.
     */
    @JvmName("lingrwnknwdoaesq")
    public suspend fun dataDisks(`value`: Output<List<DataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("waprmpycierhcaft")
    public suspend fun dataDisks(vararg values: Output<DataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Specifies the parameters that are used to add a data disk to a virtual machine.
     */
    @JvmName("kjtwqhjaegcyugtg")
    public suspend fun dataDisks(values: List<Output<DataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value The image reference properties.
     */
    @JvmName("sqjikqhaxvxvjrro")
    public suspend fun imageReference(`value`: Output<ImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machine.
     */
    @JvmName("yksyklkiqdjinfpe")
    public suspend fun osDisk(`value`: Output<OsDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value Specifies the parameters that are used to add a data disk to a virtual machine.
     */
    @JvmName("eslwvjxhmmcigcgc")
    public suspend fun dataDisks(`value`: List<DataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine.
     */
    @JvmName("tbwdtfqlvimelcrp")
    public suspend fun dataDisks(argument: List<suspend DataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DataDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine.
     */
    @JvmName("gdulkvagnhxowwlt")
    public suspend fun dataDisks(vararg argument: suspend DataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DataDiskArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Specifies the parameters that are used to add a data disk to a virtual machine.
     */
    @JvmName("nqaqjpqavlhioykd")
    public suspend fun dataDisks(argument: suspend DataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Specifies the parameters that are used to add a data disk to a virtual machine.
     */
    @JvmName("fxgpsonpdituryum")
    public suspend fun dataDisks(vararg values: DataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value The image reference properties.
     */
    @JvmName("cfnsvdmpxwlxowwu")
    public suspend fun imageReference(`value`: ImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument The image reference properties.
     */
    @JvmName("qbspbcheyrwiytgy")
    public suspend fun imageReference(argument: suspend ImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value Specifies information about the operating system disk used by the virtual machine.
     */
    @JvmName("gdrhgwgkgopnphmh")
    public suspend fun osDisk(`value`: OsDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument Specifies information about the operating system disk used by the virtual machine.
     */
    @JvmName("gyrgfeqmgelloyje")
    public suspend fun osDisk(argument: suspend OsDiskArgsBuilder.() -> Unit) {
        val toBeMapped = OsDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    internal fun build(): StorageProfileArgs = StorageProfileArgs(
        dataDisks = dataDisks,
        imageReference = imageReference,
        osDisk = osDisk,
    )
}
