@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Artifact manifest properties.
 * @property artifactManifestState The artifact manifest state.
 * @property artifacts The artifacts list.
 * @property provisioningState The provisioning state of the ArtifactManifest resource.
 */
public data class ArtifactManifestPropertiesFormatResponse(
    public val artifactManifestState: String,
    public val artifacts: List<ManifestArtifactFormatResponse>? = null,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ArtifactManifestPropertiesFormatResponse):
            ArtifactManifestPropertiesFormatResponse = ArtifactManifestPropertiesFormatResponse(
            artifactManifestState = javaType.artifactManifestState(),
            artifacts = javaType.artifacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ManifestArtifactFormatResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
