@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Artifact store properties.
 * @property managedResourceGroupConfiguration
 * @property provisioningState The provisioning state of the application groups resource.
 * @property replicationStrategy The replication strategy.
 * @property storageResourceId The created storage resource id
 * @property storeType The artifact store type.
 */
public data class ArtifactStorePropertiesFormatResponse(
    public val managedResourceGroupConfiguration:
    ArtifactStorePropertiesFormatResponseManagedResourceGroupConfiguration? = null,
    public val provisioningState: String,
    public val replicationStrategy: String? = null,
    public val storageResourceId: String,
    public val storeType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ArtifactStorePropertiesFormatResponse):
            ArtifactStorePropertiesFormatResponse = ArtifactStorePropertiesFormatResponse(
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ArtifactStorePropertiesFormatResponseManagedResourceGroupConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            replicationStrategy = javaType.replicationStrategy().map({ args0 -> args0 }).orElse(null),
            storageResourceId = javaType.storageResourceId(),
            storeType = javaType.storeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
