@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Suppress

/**
 * Azure arc kubernetes artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property helmArtifactProfile Helm artifact profile.
 */
public data class AzureArcKubernetesArtifactProfileResponse(
    public val artifactStore: ReferencedResourceResponse? = null,
    public val helmArtifactProfile: HelmArtifactProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureArcKubernetesArtifactProfileResponse):
            AzureArcKubernetesArtifactProfileResponse = AzureArcKubernetesArtifactProfileResponse(
            artifactStore = javaType.artifactStore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            helmArtifactProfile = javaType.helmArtifactProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.HelmArtifactProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
