@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Suppress

/**
 * Azure vhd artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property vhdArtifactProfile Vhd artifact profile.
 */
public data class AzureCoreVhdImageArtifactProfileResponse(
    public val artifactStore: ReferencedResourceResponse? = null,
    public val vhdArtifactProfile: VhdImageArtifactProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureCoreVhdImageArtifactProfileResponse):
            AzureCoreVhdImageArtifactProfileResponse = AzureCoreVhdImageArtifactProfileResponse(
            artifactStore = javaType.artifactStore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vhdArtifactProfile = javaType.vhdArtifactProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.VhdImageArtifactProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
