@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure Operator Distributed Services network function template.
 * @property networkFunctionApplications Network function applications.
 * @property nfviType The network function type.
 * Expected value is 'AzureOperatorNexus'.
 */
public data class AzureOperatorNexusNetworkFunctionTemplateResponse(
    public val networkFunctionApplications:
    List<Either<AzureOperatorNexusNetworkFunctionArmTemplateApplicationResponse, AzureOperatorNexusNetworkFunctionImageApplicationResponse>>? =
        null,
    public val nfviType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureOperatorNexusNetworkFunctionTemplateResponse):
            AzureOperatorNexusNetworkFunctionTemplateResponse =
            AzureOperatorNexusNetworkFunctionTemplateResponse(
                networkFunctionApplications = javaType.networkFunctionApplications().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureOperatorNexusNetworkFunctionArmTemplateApplicationResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.AzureOperatorNexusNetworkFunctionImageApplicationResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }),
                nfviType = javaType.nfviType(),
            )
    }
}
