@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration group schema properties.
 * @property description Description of what schema can contain.
 * @property provisioningState The provisioning state of the Configuration group schema resource.
 * @property schemaDefinition Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
 * @property versionState The configuration group schema version state.
 */
public data class ConfigurationGroupSchemaPropertiesFormatResponse(
    public val description: String? = null,
    public val provisioningState: String,
    public val schemaDefinition: String? = null,
    public val versionState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ConfigurationGroupSchemaPropertiesFormatResponse):
            ConfigurationGroupSchemaPropertiesFormatResponse =
            ConfigurationGroupSchemaPropertiesFormatResponse(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                schemaDefinition = javaType.schemaDefinition().map({ args0 -> args0 }).orElse(null),
                versionState = javaType.versionState(),
            )
    }
}
