@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Depends on profile definition.
 * @property installDependsOn Application installation operation dependency.
 * @property uninstallDependsOn Application deletion operation dependency.
 * @property updateDependsOn Application update operation dependency.
 */
public data class DependsOnProfileResponse(
    public val installDependsOn: List<String>? = null,
    public val uninstallDependsOn: List<String>? = null,
    public val updateDependsOn: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.DependsOnProfileResponse):
            DependsOnProfileResponse = DependsOnProfileResponse(
            installDependsOn = javaType.installDependsOn().map({ args0 -> args0 }),
            uninstallDependsOn = javaType.uninstallDependsOn().map({ args0 -> args0 }),
            updateDependsOn = javaType.updateDependsOn().map({ args0 -> args0 }),
        )
    }
}
