@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Network function resource response.
 * @property device The reference to the device resource. Once set, it cannot be updated.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property managedApplication The resource URI of the managed application.
 * @property managedApplicationParameters The parameters for the managed application.
 * @property name The name of the resource
 * @property networkFunctionContainerConfigurations The network function container configurations from the user.
 * @property networkFunctionUserConfigurations The network function configurations from the user.
 * @property provisioningState The provisioning state of the network function resource.
 * @property serviceKey The service key for the network function resource.
 * @property skuName The sku name for the network function. Once set, it cannot be updated.
 * @property skuType The sku type for the network function.
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vendorName The vendor name for the network function. Once set, it cannot be updated.
 * @property vendorProvisioningState The vendor provisioning state for the network function resource.
 */
public data class GetNetworkFunctionResult(
    public val device: SubResourceResponse? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val managedApplication: SubResourceResponse,
    public val managedApplicationParameters: Any? = null,
    public val name: String,
    public val networkFunctionContainerConfigurations: Any? = null,
    public val networkFunctionUserConfigurations: List<NetworkFunctionUserConfigurationResponse>? =
        null,
    public val provisioningState: String,
    public val serviceKey: String,
    public val skuName: String? = null,
    public val skuType: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vendorName: String? = null,
    public val vendorProvisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.GetNetworkFunctionResult):
            GetNetworkFunctionResult = GetNetworkFunctionResult(
            device = javaType.device().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            managedApplication = javaType.managedApplication().let({ args0 ->
                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            managedApplicationParameters = javaType.managedApplicationParameters().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            networkFunctionContainerConfigurations = javaType.networkFunctionContainerConfigurations().map({ args0 ->
                args0
            }).orElse(null),
            networkFunctionUserConfigurations = javaType.networkFunctionUserConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.NetworkFunctionUserConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            serviceKey = javaType.serviceKey(),
            skuName = javaType.skuName().map({ args0 -> args0 }).orElse(null),
            skuType = javaType.skuType(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hybridnetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vendorName = javaType.vendorName().map({ args0 -> args0 }).orElse(null),
            vendorProvisioningState = javaType.vendorProvisioningState(),
        )
    }
}
