@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Image artifact profile.
 * @property imageName Image name.
 * @property imageVersion Image version.
 */
public data class ImageArtifactProfileResponse(
    public val imageName: String? = null,
    public val imageVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ImageArtifactProfileResponse):
            ImageArtifactProfileResponse = ImageArtifactProfileResponse(
            imageName = javaType.imageName().map({ args0 -> args0 }).orElse(null),
            imageVersion = javaType.imageVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
