@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Manifest artifact properties.
 * @property artifactName The artifact name
 * @property artifactType The artifact type.
 * @property artifactVersion The artifact version.
 */
public data class ManifestArtifactFormatResponse(
    public val artifactName: String? = null,
    public val artifactType: String? = null,
    public val artifactVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ManifestArtifactFormatResponse):
            ManifestArtifactFormatResponse = ManifestArtifactFormatResponse(
            artifactName = javaType.artifactName().map({ args0 -> args0 }).orElse(null),
            artifactType = javaType.artifactType().map({ args0 -> args0 }).orElse(null),
            artifactVersion = javaType.artifactVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
