@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Specifies information about the operating system disk used by the virtual machine. <br><br> For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json).
 * @property diskSizeGB Specifies the size of os disk in gigabytes. This is the fully expanded disk size needed of the VHD image on the ASE. This disk size should be greater than the size of the VHD provided in vhdUri.
 * @property name The VHD name.
 * @property osType The OS type.
 */
public data class OsDiskResponse(
    public val diskSizeGB: Int? = null,
    public val name: String? = null,
    public val osType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.OsDiskResponse):
            OsDiskResponse = OsDiskResponse(
            diskSizeGB = javaType.diskSizeGB().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
