@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * publisher properties.
 * @property provisioningState The provisioning state of the publisher resource.
 * @property scope The publisher scope.
 */
public data class PublisherPropertiesFormatResponse(
    public val provisioningState: String,
    public val scope: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.PublisherPropertiesFormatResponse):
            PublisherPropertiesFormatResponse = PublisherPropertiesFormatResponse(
            provisioningState = javaType.provisioningState(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
        )
    }
}
