@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin

import com.pulumi.azurenative.importexport.ImportexportFunctions.getJobPlain
import com.pulumi.azurenative.importexport.ImportexportFunctions.listBitLockerKeyPlain
import com.pulumi.azurenative.importexport.kotlin.inputs.GetJobPlainArgs
import com.pulumi.azurenative.importexport.kotlin.inputs.GetJobPlainArgsBuilder
import com.pulumi.azurenative.importexport.kotlin.inputs.ListBitLockerKeyPlainArgs
import com.pulumi.azurenative.importexport.kotlin.inputs.ListBitLockerKeyPlainArgsBuilder
import com.pulumi.azurenative.importexport.kotlin.outputs.GetJobResult
import com.pulumi.azurenative.importexport.kotlin.outputs.ListBitLockerKeyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.importexport.kotlin.outputs.GetJobResult.Companion.toKotlin as getJobResultToKotlin
import com.pulumi.azurenative.importexport.kotlin.outputs.ListBitLockerKeyResult.Companion.toKotlin as listBitLockerKeyResultToKotlin

public object ImportexportFunctions {
    /**
     * Gets information about an existing job.
     * Azure REST API version: 2021-01-01.
     * @param argument null
     * @return Contains the job information.
     */
    public suspend fun getJob(argument: GetJobPlainArgs): GetJobResult =
        getJobResultToKotlin(getJobPlain(argument.toJava()).await())

    /**
     * @see [getJob].
     * @param jobName The name of the import/export job.
     * @param resourceGroupName The resource group name uniquely identifies the resource group within the user subscription.
     * @return Contains the job information.
     */
    public suspend fun getJob(jobName: String, resourceGroupName: String): GetJobResult {
        val argument = GetJobPlainArgs(
            jobName = jobName,
            resourceGroupName = resourceGroupName,
        )
        return getJobResultToKotlin(getJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getJob].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;importexport&#46;kotlin&#46;inputs&#46;GetJobPlainArgs].
     * @return Contains the job information.
     */
    public suspend fun getJob(argument: suspend GetJobPlainArgsBuilder.() -> Unit): GetJobResult {
        val builder = GetJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobResultToKotlin(getJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the BitLocker Keys for all drives in the specified job.
     * Azure REST API version: 2021-01-01.
     * @param argument null
     * @return GetBitLockerKeys response
     */
    public suspend fun listBitLockerKey(argument: ListBitLockerKeyPlainArgs): ListBitLockerKeyResult =
        listBitLockerKeyResultToKotlin(listBitLockerKeyPlain(argument.toJava()).await())

    /**
     * @see [listBitLockerKey].
     * @param jobName The name of the import/export job.
     * @param resourceGroupName The resource group name uniquely identifies the resource group within the user subscription.
     * @return GetBitLockerKeys response
     */
    public suspend fun listBitLockerKey(jobName: String, resourceGroupName: String):
        ListBitLockerKeyResult {
        val argument = ListBitLockerKeyPlainArgs(
            jobName = jobName,
            resourceGroupName = resourceGroupName,
        )
        return listBitLockerKeyResultToKotlin(listBitLockerKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [listBitLockerKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;importexport&#46;kotlin&#46;inputs&#46;ListBitLockerKeyPlainArgs].
     * @return GetBitLockerKeys response
     */
    public suspend
    fun listBitLockerKey(argument: suspend ListBitLockerKeyPlainArgsBuilder.() -> Unit):
        ListBitLockerKeyResult {
        val builder = ListBitLockerKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBitLockerKeyResultToKotlin(listBitLockerKeyPlain(builtArgument.toJava()).await())
    }
}
