@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.ShippingInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about the Microsoft datacenter to which the drives should be shipped.
 * @property city The city name to use when returning the drives.
 * @property countryOrRegion The country or region to use when returning the drives.
 * @property phone Phone number of the recipient of the returned drives.
 * @property postalCode The postal code to use when returning the drives.
 * @property recipientName The name of the recipient who will receive the hard drives when they are returned.
 * @property stateOrProvince The state or province to use when returning the drives.
 * @property streetAddress1 The first line of the street address to use when returning the drives.
 * @property streetAddress2 The second line of the street address to use when returning the drives.
 */
public data class ShippingInformationArgs(
    public val city: Output<String>? = null,
    public val countryOrRegion: Output<String>? = null,
    public val phone: Output<String>? = null,
    public val postalCode: Output<String>? = null,
    public val recipientName: Output<String>? = null,
    public val stateOrProvince: Output<String>? = null,
    public val streetAddress1: Output<String>? = null,
    public val streetAddress2: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.ShippingInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.ShippingInformationArgs =
        com.pulumi.azurenative.importexport.inputs.ShippingInformationArgs.builder()
            .city(city?.applyValue({ args0 -> args0 }))
            .countryOrRegion(countryOrRegion?.applyValue({ args0 -> args0 }))
            .phone(phone?.applyValue({ args0 -> args0 }))
            .postalCode(postalCode?.applyValue({ args0 -> args0 }))
            .recipientName(recipientName?.applyValue({ args0 -> args0 }))
            .stateOrProvince(stateOrProvince?.applyValue({ args0 -> args0 }))
            .streetAddress1(streetAddress1?.applyValue({ args0 -> args0 }))
            .streetAddress2(streetAddress2?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShippingInformationArgs].
 */
@PulumiTagMarker
public class ShippingInformationArgsBuilder internal constructor() {
    private var city: Output<String>? = null

    private var countryOrRegion: Output<String>? = null

    private var phone: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var recipientName: Output<String>? = null

    private var stateOrProvince: Output<String>? = null

    private var streetAddress1: Output<String>? = null

    private var streetAddress2: Output<String>? = null

    /**
     * @param value The city name to use when returning the drives.
     */
    @JvmName("djrttyhjrunlqxgv")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value The country or region to use when returning the drives.
     */
    @JvmName("cqxgnkxpufgbjmyh")
    public suspend fun countryOrRegion(`value`: Output<String>) {
        this.countryOrRegion = value
    }

    /**
     * @param value Phone number of the recipient of the returned drives.
     */
    @JvmName("oywlwkqudpntssyl")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value The postal code to use when returning the drives.
     */
    @JvmName("nichiknouhkiwlcs")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value The name of the recipient who will receive the hard drives when they are returned.
     */
    @JvmName("wcwsusmcsulyigll")
    public suspend fun recipientName(`value`: Output<String>) {
        this.recipientName = value
    }

    /**
     * @param value The state or province to use when returning the drives.
     */
    @JvmName("ixmhuroovjhrhcur")
    public suspend fun stateOrProvince(`value`: Output<String>) {
        this.stateOrProvince = value
    }

    /**
     * @param value The first line of the street address to use when returning the drives.
     */
    @JvmName("icvxydnqanbxtsgg")
    public suspend fun streetAddress1(`value`: Output<String>) {
        this.streetAddress1 = value
    }

    /**
     * @param value The second line of the street address to use when returning the drives.
     */
    @JvmName("yqbufjlxpwidwoti")
    public suspend fun streetAddress2(`value`: Output<String>) {
        this.streetAddress2 = value
    }

    /**
     * @param value The city name to use when returning the drives.
     */
    @JvmName("wcfxttvtodelveqv")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value The country or region to use when returning the drives.
     */
    @JvmName("ulkiqeogpdqijolk")
    public suspend fun countryOrRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryOrRegion = mapped
    }

    /**
     * @param value Phone number of the recipient of the returned drives.
     */
    @JvmName("aaxqrgjsrmvmmxfn")
    public suspend fun phone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value The postal code to use when returning the drives.
     */
    @JvmName("djfghnmpqsbvaeob")
    public suspend fun postalCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value The name of the recipient who will receive the hard drives when they are returned.
     */
    @JvmName("bidnxisprranjgwq")
    public suspend fun recipientName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recipientName = mapped
    }

    /**
     * @param value The state or province to use when returning the drives.
     */
    @JvmName("ubdumqbstbiqynop")
    public suspend fun stateOrProvince(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stateOrProvince = mapped
    }

    /**
     * @param value The first line of the street address to use when returning the drives.
     */
    @JvmName("ydngrvlcxoqqjkmp")
    public suspend fun streetAddress1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress1 = mapped
    }

    /**
     * @param value The second line of the street address to use when returning the drives.
     */
    @JvmName("kirvvlowlyxvptnf")
    public suspend fun streetAddress2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress2 = mapped
    }

    internal fun build(): ShippingInformationArgs = ShippingInformationArgs(
        city = city,
        countryOrRegion = countryOrRegion,
        phone = phone,
        postalCode = postalCode,
        recipientName = recipientName,
        stateOrProvince = stateOrProvince,
        streetAddress1 = streetAddress1,
        streetAddress2 = streetAddress2,
    )
}
