@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ActionGroupArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.ArmRoleReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ArmRoleReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AutomationRunbookReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AutomationRunbookReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AzureAppPushReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AzureAppPushReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AzureFunctionReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AzureFunctionReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.EmailReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.EmailReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.EventHubReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.EventHubReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.ItsmReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ItsmReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.LogicAppReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.LogicAppReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.SmsReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.SmsReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.VoiceReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.VoiceReceiverArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.WebhookReceiverArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WebhookReceiverArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An action group resource.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2019-06-01.
 * ## Example Usage
 * ### Create or update an action group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var actionGroup = new AzureNative.Insights.ActionGroup("actionGroup", new()
 *     {
 *         ActionGroupName = "SampleActionGroup",
 *         ArmRoleReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ArmRoleReceiverArgs
 *             {
 *                 Name = "Sample armRole",
 *                 RoleId = "8e3af657-a8ff-443c-a75c-2fe8c4bcb635",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         AutomationRunbookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AutomationRunbookReceiverArgs
 *             {
 *                 AutomationAccountId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest",
 *                 IsGlobalRunbook = false,
 *                 Name = "testRunbook",
 *                 RunbookName = "Sample runbook",
 *                 ServiceUri = "<serviceUri>",
 *                 UseCommonAlertSchema = true,
 *                 WebhookResourceId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084",
 *             },
 *         },
 *         AzureAppPushReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureAppPushReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "Sample azureAppPush",
 *             },
 *         },
 *         AzureFunctionReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureFunctionReceiverArgs
 *             {
 *                 FunctionAppResourceId = "/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp",
 *                 FunctionName = "HttpTriggerCSharp1",
 *                 HttpTriggerUrl = "http://test.me",
 *                 Name = "Sample azureFunction",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         EmailReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "John Doe's email",
 *                 UseCommonAlertSchema = false,
 *             },
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "janesmith@email.com",
 *                 Name = "Jane Smith's email",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         Enabled = true,
 *         EventHubReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EventHubReceiverArgs
 *             {
 *                 EventHubName = "testEventHub",
 *                 EventHubNameSpace = "testEventHubNameSpace",
 *                 Name = "Sample eventHub",
 *                 SubscriptionId = "187f412d-1758-44d9-b052-169e2564721d",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *             },
 *         },
 *         GroupShortName = "sample",
 *         ItsmReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.ItsmReceiverArgs
 *             {
 *                 ConnectionId = "a3b9076c-ce8e-434e-85b4-aff10cb3c8f1",
 *                 Name = "Sample itsm",
 *                 Region = "westcentralus",
 *                 TicketConfiguration = "{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}",
 *                 WorkspaceId = "5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c",
 *             },
 *         },
 *         Location = "Global",
 *         LogicAppReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.LogicAppReceiverArgs
 *             {
 *                 CallbackUrl = "https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w",
 *                 Name = "Sample logicApp",
 *                 ResourceId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp",
 *                 UseCommonAlertSchema = false,
 *             },
 *         },
 *         ResourceGroupName = "Default-NotificationRules",
 *         SmsReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "John Doe's mobile",
 *                 PhoneNumber = "1234567890",
 *             },
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Jane Smith's mobile",
 *                 PhoneNumber = "0987654321",
 *             },
 *         },
 *         Tags = null,
 *         VoiceReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.VoiceReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Sample voice",
 *                 PhoneNumber = "1234567890",
 *             },
 *         },
 *         WebhookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 Name = "Sample webhook 1",
 *                 ServiceUri = "http://www.example.com/webhook1",
 *                 UseCommonAlertSchema = true,
 *             },
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 IdentifierUri = "http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a",
 *                 Name = "Sample webhook 2",
 *                 ObjectId = "d3bb868c-fe44-452c-aa26-769a6538c808",
 *                 ServiceUri = "http://www.example.com/webhook2",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *                 UseAadAuth = true,
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActionGroup(ctx, "actionGroup", &insights.ActionGroupArgs{
 * 			ActionGroupName: pulumi.String("SampleActionGroup"),
 * 			ArmRoleReceivers: []insights.ArmRoleReceiverArgs{
 * 				{
 * 					Name:                 pulumi.String("Sample armRole"),
 * 					RoleId:               pulumi.String("8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			AutomationRunbookReceivers: []insights.AutomationRunbookReceiverArgs{
 * 				{
 * 					AutomationAccountId:  pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest"),
 * 					IsGlobalRunbook:      pulumi.Bool(false),
 * 					Name:                 pulumi.String("testRunbook"),
 * 					RunbookName:          pulumi.String("Sample runbook"),
 * 					ServiceUri:           pulumi.String("<serviceUri>"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 					WebhookResourceId:    pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084"),
 * 				},
 * 			},
 * 			AzureAppPushReceivers: []insights.AzureAppPushReceiverArgs{
 * 				{
 * 					EmailAddress: pulumi.String("johndoe@email.com"),
 * 					Name:         pulumi.String("Sample azureAppPush"),
 * 				},
 * 			},
 * 			AzureFunctionReceivers: []insights.AzureFunctionReceiverArgs{
 * 				{
 * 					FunctionAppResourceId: pulumi.String("/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp"),
 * 					FunctionName:          pulumi.String("HttpTriggerCSharp1"),
 * 					HttpTriggerUrl:        pulumi.String("http://test.me"),
 * 					Name:                  pulumi.String("Sample azureFunction"),
 * 					UseCommonAlertSchema:  pulumi.Bool(true),
 * 				},
 * 			},
 * 			EmailReceivers: []insights.EmailReceiverArgs{
 * 				{
 * 					EmailAddress:         pulumi.String("johndoe@email.com"),
 * 					Name:                 pulumi.String("John Doe's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 				{
 * 					EmailAddress:         pulumi.String("janesmith@email.com"),
 * 					Name:                 pulumi.String("Jane Smith's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			Enabled: pulumi.Bool(true),
 * 			EventHubReceivers: []insights.EventHubReceiverArgs{
 * 				{
 * 					EventHubName:      pulumi.String("testEventHub"),
 * 					EventHubNameSpace: pulumi.String("testEventHubNameSpace"),
 * 					Name:              pulumi.String("Sample eventHub"),
 * 					SubscriptionId:    pulumi.String("187f412d-1758-44d9-b052-169e2564721d"),
 * 					TenantId:          pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 				},
 * 			},
 * 			GroupShortName: pulumi.String("sample"),
 * 			ItsmReceivers: []insights.ItsmReceiverArgs{
 * 				{
 * 					ConnectionId:        pulumi.String("a3b9076c-ce8e-434e-85b4-aff10cb3c8f1"),
 * 					Name:                pulumi.String("Sample itsm"),
 * 					Region:              pulumi.String("westcentralus"),
 * 					TicketConfiguration: pulumi.String("{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}"),
 * 					WorkspaceId:         pulumi.String("5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c"),
 * 				},
 * 			},
 * 			Location: pulumi.String("Global"),
 * 			LogicAppReceivers: []insights.LogicAppReceiverArgs{
 * 				{
 * 					CallbackUrl:          pulumi.String("https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w"),
 * 					Name:                 pulumi.String("Sample logicApp"),
 * 					ResourceId:           pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("Default-NotificationRules"),
 * 			SmsReceivers: []insights.SmsReceiverArgs{
 * 				{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("John Doe's mobile"),
 * 					PhoneNumber: pulumi.String("1234567890"),
 * 				},
 * 				{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Jane Smith's mobile"),
 * 					PhoneNumber: pulumi.String("0987654321"),
 * 				},
 * 			},
 * 			Tags: nil,
 * 			VoiceReceivers: []insights.VoiceReceiverArgs{
 * 				{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Sample voice"),
 * 					PhoneNumber: pulumi.String("1234567890"),
 * 				},
 * 			},
 * 			WebhookReceivers: []insights.WebhookReceiverArgs{
 * 				{
 * 					Name:                 pulumi.String("Sample webhook 1"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook1"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 				{
 * 					IdentifierUri:        pulumi.String("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
 * 					Name:                 pulumi.String("Sample webhook 2"),
 * 					ObjectId:             pulumi.String("d3bb868c-fe44-452c-aa26-769a6538c808"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook2"),
 * 					TenantId:             pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 					UseAadAuth:           pulumi.Bool(true),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActionGroup;
 * import com.pulumi.azurenative.insights.ActionGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var actionGroup = new ActionGroup("actionGroup", ActionGroupArgs.builder()
 *             .actionGroupName("SampleActionGroup")
 *             .armRoleReceivers(Map.ofEntries(
 *                 Map.entry("name", "Sample armRole"),
 *                 Map.entry("roleId", "8e3af657-a8ff-443c-a75c-2fe8c4bcb635"),
 *                 Map.entry("useCommonAlertSchema", true)
 *             ))
 *             .automationRunbookReceivers(Map.ofEntries(
 *                 Map.entry("automationAccountId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest"),
 *                 Map.entry("isGlobalRunbook", false),
 *                 Map.entry("name", "testRunbook"),
 *                 Map.entry("runbookName", "Sample runbook"),
 *                 Map.entry("serviceUri", "<serviceUri>"),
 *                 Map.entry("useCommonAlertSchema", true),
 *                 Map.entry("webhookResourceId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/runbookTest/providers/Microsoft.Automation/automationAccounts/runbooktest/webhooks/Alert1510184037084")
 *             ))
 *             .azureAppPushReceivers(Map.ofEntries(
 *                 Map.entry("emailAddress", "johndoe@email.com"),
 *                 Map.entry("name", "Sample azureAppPush")
 *             ))
 *             .azureFunctionReceivers(Map.ofEntries(
 *                 Map.entry("functionAppResourceId", "/subscriptions/5def922a-3ed4-49c1-b9fd-05ec533819a3/resourceGroups/aznsTest/providers/Microsoft.Web/sites/testFunctionApp"),
 *                 Map.entry("functionName", "HttpTriggerCSharp1"),
 *                 Map.entry("httpTriggerUrl", "http://test.me"),
 *                 Map.entry("name", "Sample azureFunction"),
 *                 Map.entry("useCommonAlertSchema", true)
 *             ))
 *             .emailReceivers(
 *                 Map.ofEntries(
 *                     Map.entry("emailAddress", "johndoe@email.com"),
 *                     Map.entry("name", "John Doe's email"),
 *                     Map.entry("useCommonAlertSchema", false)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("emailAddress", "janesmith@email.com"),
 *                     Map.entry("name", "Jane Smith's email"),
 *                     Map.entry("useCommonAlertSchema", true)
 *                 ))
 *             .enabled(true)
 *             .eventHubReceivers(Map.ofEntries(
 *                 Map.entry("eventHubName", "testEventHub"),
 *                 Map.entry("eventHubNameSpace", "testEventHubNameSpace"),
 *                 Map.entry("name", "Sample eventHub"),
 *                 Map.entry("subscriptionId", "187f412d-1758-44d9-b052-169e2564721d"),
 *                 Map.entry("tenantId", "68a4459a-ccb8-493c-b9da-dd30457d1b84")
 *             ))
 *             .groupShortName("sample")
 *             .itsmReceivers(Map.ofEntries(
 *                 Map.entry("connectionId", "a3b9076c-ce8e-434e-85b4-aff10cb3c8f1"),
 *                 Map.entry("name", "Sample itsm"),
 *                 Map.entry("region", "westcentralus"),
 *                 Map.entry("ticketConfiguration", "{\"PayloadRevision\":0,\"WorkItemType\":\"Incident\",\"UseTemplate\":false,\"WorkItemData\":\"{}\",\"CreateOneWIPerCI\":false}"),
 *                 Map.entry("workspaceId", "5def922a-3ed4-49c1-b9fd-05ec533819a3|55dfd1f8-7e59-4f89-bf56-4c82f5ace23c")
 *             ))
 *             .location("Global")
 *             .logicAppReceivers(Map.ofEntries(
 *                 Map.entry("callbackUrl", "https://prod-27.northcentralus.logic.azure.com/workflows/68e572e818e5457ba898763b7db90877/triggers/manual/paths/invoke/azns/test?api-version=2016-10-01&sp=%2Ftriggers%2Fmanual%2Frun&sv=1.0&sig=Abpsb72UYJxPPvmDo937uzofupO5r_vIeWEx7KVHo7w"),
 *                 Map.entry("name", "Sample logicApp"),
 *                 Map.entry("resourceId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/LogicApp/providers/Microsoft.Logic/workflows/testLogicApp"),
 *                 Map.entry("useCommonAlertSchema", false)
 *             ))
 *             .resourceGroupName("Default-NotificationRules")
 *             .smsReceivers(
 *                 Map.ofEntries(
 *                     Map.entry("countryCode", "1"),
 *                     Map.entry("name", "John Doe's mobile"),
 *                     Map.entry("phoneNumber", "1234567890")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("countryCode", "1"),
 *                     Map.entry("name", "Jane Smith's mobile"),
 *                     Map.entry("phoneNumber", "0987654321")
 *                 ))
 *             .tags()
 *             .voiceReceivers(Map.ofEntries(
 *                 Map.entry("countryCode", "1"),
 *                 Map.entry("name", "Sample voice"),
 *                 Map.entry("phoneNumber", "1234567890")
 *             ))
 *             .webhookReceivers(
 *                 Map.ofEntries(
 *                     Map.entry("name", "Sample webhook 1"),
 *                     Map.entry("serviceUri", "http://www.example.com/webhook1"),
 *                     Map.entry("useCommonAlertSchema", true)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("identifierUri", "http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
 *                     Map.entry("name", "Sample webhook 2"),
 *                     Map.entry("objectId", "d3bb868c-fe44-452c-aa26-769a6538c808"),
 *                     Map.entry("serviceUri", "http://www.example.com/webhook2"),
 *                     Map.entry("tenantId", "68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 *                     Map.entry("useAadAuth", true),
 *                     Map.entry("useCommonAlertSchema", true)
 *                 ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ActionGroup SampleActionGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}
 * ```
 * @property actionGroupName The name of the action group.
 * @property armRoleReceivers The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
 * @property automationRunbookReceivers The list of AutomationRunbook receivers that are part of this action group.
 * @property azureAppPushReceivers The list of AzureAppPush receivers that are part of this action group.
 * @property azureFunctionReceivers The list of azure function receivers that are part of this action group.
 * @property emailReceivers The list of email receivers that are part of this action group.
 * @property enabled Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
 * @property eventHubReceivers The list of event hub receivers that are part of this action group.
 * @property groupShortName The short name of the action group. This will be used in SMS messages.
 * @property itsmReceivers The list of ITSM receivers that are part of this action group.
 * @property location Resource location
 * @property logicAppReceivers The list of logic app receivers that are part of this action group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property smsReceivers The list of SMS receivers that are part of this action group.
 * @property tags Resource tags
 * @property voiceReceivers The list of voice receivers that are part of this action group.
 * @property webhookReceivers The list of webhook receivers that are part of this action group.
 */
public data class ActionGroupArgs(
    public val actionGroupName: Output<String>? = null,
    public val armRoleReceivers: Output<List<ArmRoleReceiverArgs>>? = null,
    public val automationRunbookReceivers: Output<List<AutomationRunbookReceiverArgs>>? = null,
    public val azureAppPushReceivers: Output<List<AzureAppPushReceiverArgs>>? = null,
    public val azureFunctionReceivers: Output<List<AzureFunctionReceiverArgs>>? = null,
    public val emailReceivers: Output<List<EmailReceiverArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val eventHubReceivers: Output<List<EventHubReceiverArgs>>? = null,
    public val groupShortName: Output<String>? = null,
    public val itsmReceivers: Output<List<ItsmReceiverArgs>>? = null,
    public val location: Output<String>? = null,
    public val logicAppReceivers: Output<List<LogicAppReceiverArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val smsReceivers: Output<List<SmsReceiverArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val voiceReceivers: Output<List<VoiceReceiverArgs>>? = null,
    public val webhookReceivers: Output<List<WebhookReceiverArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ActionGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ActionGroupArgs =
        com.pulumi.azurenative.insights.ActionGroupArgs.builder()
            .actionGroupName(actionGroupName?.applyValue({ args0 -> args0 }))
            .armRoleReceivers(
                armRoleReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .automationRunbookReceivers(
                automationRunbookReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureAppPushReceivers(
                azureAppPushReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureFunctionReceivers(
                azureFunctionReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .emailReceivers(
                emailReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventHubReceivers(
                eventHubReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .groupShortName(groupShortName?.applyValue({ args0 -> args0 }))
            .itsmReceivers(
                itsmReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .logicAppReceivers(
                logicAppReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .smsReceivers(
                smsReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .voiceReceivers(
                voiceReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .webhookReceivers(
                webhookReceivers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ActionGroupArgs].
 */
@PulumiTagMarker
public class ActionGroupArgsBuilder internal constructor() {
    private var actionGroupName: Output<String>? = null

    private var armRoleReceivers: Output<List<ArmRoleReceiverArgs>>? = null

    private var automationRunbookReceivers: Output<List<AutomationRunbookReceiverArgs>>? = null

    private var azureAppPushReceivers: Output<List<AzureAppPushReceiverArgs>>? = null

    private var azureFunctionReceivers: Output<List<AzureFunctionReceiverArgs>>? = null

    private var emailReceivers: Output<List<EmailReceiverArgs>>? = null

    private var enabled: Output<Boolean>? = null

    private var eventHubReceivers: Output<List<EventHubReceiverArgs>>? = null

    private var groupShortName: Output<String>? = null

    private var itsmReceivers: Output<List<ItsmReceiverArgs>>? = null

    private var location: Output<String>? = null

    private var logicAppReceivers: Output<List<LogicAppReceiverArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var smsReceivers: Output<List<SmsReceiverArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var voiceReceivers: Output<List<VoiceReceiverArgs>>? = null

    private var webhookReceivers: Output<List<WebhookReceiverArgs>>? = null

    /**
     * @param value The name of the action group.
     */
    @JvmName("xitxyyvycdnwqslh")
    public suspend fun actionGroupName(`value`: Output<String>) {
        this.actionGroupName = value
    }

    /**
     * @param value The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("rvvegouslgqektbu")
    public suspend fun armRoleReceivers(`value`: Output<List<ArmRoleReceiverArgs>>) {
        this.armRoleReceivers = value
    }

    @JvmName("prhaldlvuxitidiy")
    public suspend fun armRoleReceivers(vararg values: Output<ArmRoleReceiverArgs>) {
        this.armRoleReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("mfjuugtndnvdvpgq")
    public suspend fun armRoleReceivers(values: List<Output<ArmRoleReceiverArgs>>) {
        this.armRoleReceivers = Output.all(values)
    }

    /**
     * @param value The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("vqnhqcdaculvywug")
    public suspend
    fun automationRunbookReceivers(`value`: Output<List<AutomationRunbookReceiverArgs>>) {
        this.automationRunbookReceivers = value
    }

    @JvmName("nvcjilbpytrwgvfk")
    public suspend fun automationRunbookReceivers(
        vararg
        values: Output<AutomationRunbookReceiverArgs>,
    ) {
        this.automationRunbookReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("yybgojlkaipvknim")
    public suspend
    fun automationRunbookReceivers(values: List<Output<AutomationRunbookReceiverArgs>>) {
        this.automationRunbookReceivers = Output.all(values)
    }

    /**
     * @param value The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("xdqfdtinymclfbip")
    public suspend fun azureAppPushReceivers(`value`: Output<List<AzureAppPushReceiverArgs>>) {
        this.azureAppPushReceivers = value
    }

    @JvmName("pdpbglkkdwagqaqi")
    public suspend fun azureAppPushReceivers(vararg values: Output<AzureAppPushReceiverArgs>) {
        this.azureAppPushReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("npwpjeayqdwoqeod")
    public suspend fun azureAppPushReceivers(values: List<Output<AzureAppPushReceiverArgs>>) {
        this.azureAppPushReceivers = Output.all(values)
    }

    /**
     * @param value The list of azure function receivers that are part of this action group.
     */
    @JvmName("htnghvtjcycxasco")
    public suspend fun azureFunctionReceivers(`value`: Output<List<AzureFunctionReceiverArgs>>) {
        this.azureFunctionReceivers = value
    }

    @JvmName("glahtlgnkrepaotv")
    public suspend fun azureFunctionReceivers(vararg values: Output<AzureFunctionReceiverArgs>) {
        this.azureFunctionReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of azure function receivers that are part of this action group.
     */
    @JvmName("gjkkjaneojtdmdch")
    public suspend fun azureFunctionReceivers(values: List<Output<AzureFunctionReceiverArgs>>) {
        this.azureFunctionReceivers = Output.all(values)
    }

    /**
     * @param value The list of email receivers that are part of this action group.
     */
    @JvmName("xbvsfpijymhipfff")
    public suspend fun emailReceivers(`value`: Output<List<EmailReceiverArgs>>) {
        this.emailReceivers = value
    }

    @JvmName("qnchutdbxiakibeu")
    public suspend fun emailReceivers(vararg values: Output<EmailReceiverArgs>) {
        this.emailReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of email receivers that are part of this action group.
     */
    @JvmName("bcdracvaxlwcycmx")
    public suspend fun emailReceivers(values: List<Output<EmailReceiverArgs>>) {
        this.emailReceivers = Output.all(values)
    }

    /**
     * @param value Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
     */
    @JvmName("xoctcuhhyeywftcd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The list of event hub receivers that are part of this action group.
     */
    @JvmName("sxdceonfwxewdxhf")
    public suspend fun eventHubReceivers(`value`: Output<List<EventHubReceiverArgs>>) {
        this.eventHubReceivers = value
    }

    @JvmName("wlgpcuhkhoqsdkij")
    public suspend fun eventHubReceivers(vararg values: Output<EventHubReceiverArgs>) {
        this.eventHubReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of event hub receivers that are part of this action group.
     */
    @JvmName("yhstvtufjashgsql")
    public suspend fun eventHubReceivers(values: List<Output<EventHubReceiverArgs>>) {
        this.eventHubReceivers = Output.all(values)
    }

    /**
     * @param value The short name of the action group. This will be used in SMS messages.
     */
    @JvmName("eypvxegqkkyslcjs")
    public suspend fun groupShortName(`value`: Output<String>) {
        this.groupShortName = value
    }

    /**
     * @param value The list of ITSM receivers that are part of this action group.
     */
    @JvmName("jhbgpdrytlslyrft")
    public suspend fun itsmReceivers(`value`: Output<List<ItsmReceiverArgs>>) {
        this.itsmReceivers = value
    }

    @JvmName("dwsfqacvnlqckabk")
    public suspend fun itsmReceivers(vararg values: Output<ItsmReceiverArgs>) {
        this.itsmReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of ITSM receivers that are part of this action group.
     */
    @JvmName("ufcdlsumcxeefmlk")
    public suspend fun itsmReceivers(values: List<Output<ItsmReceiverArgs>>) {
        this.itsmReceivers = Output.all(values)
    }

    /**
     * @param value Resource location
     */
    @JvmName("yccgqjhfhhnooglk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The list of logic app receivers that are part of this action group.
     */
    @JvmName("wqthherhtepvkylm")
    public suspend fun logicAppReceivers(`value`: Output<List<LogicAppReceiverArgs>>) {
        this.logicAppReceivers = value
    }

    @JvmName("bsphsuohthhumfnj")
    public suspend fun logicAppReceivers(vararg values: Output<LogicAppReceiverArgs>) {
        this.logicAppReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of logic app receivers that are part of this action group.
     */
    @JvmName("trlatcpvjkckhayk")
    public suspend fun logicAppReceivers(values: List<Output<LogicAppReceiverArgs>>) {
        this.logicAppReceivers = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qyrhljphdjgaivap")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The list of SMS receivers that are part of this action group.
     */
    @JvmName("vdmfopqcopjwbjai")
    public suspend fun smsReceivers(`value`: Output<List<SmsReceiverArgs>>) {
        this.smsReceivers = value
    }

    @JvmName("gpqpibipqcbhpscy")
    public suspend fun smsReceivers(vararg values: Output<SmsReceiverArgs>) {
        this.smsReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of SMS receivers that are part of this action group.
     */
    @JvmName("iulwoqibptkerwro")
    public suspend fun smsReceivers(values: List<Output<SmsReceiverArgs>>) {
        this.smsReceivers = Output.all(values)
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ljtuyjcwisucbxyw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of voice receivers that are part of this action group.
     */
    @JvmName("eprbbnomdfttscip")
    public suspend fun voiceReceivers(`value`: Output<List<VoiceReceiverArgs>>) {
        this.voiceReceivers = value
    }

    @JvmName("yxsukqlfedstgnni")
    public suspend fun voiceReceivers(vararg values: Output<VoiceReceiverArgs>) {
        this.voiceReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of voice receivers that are part of this action group.
     */
    @JvmName("smqbcpglxwyshwas")
    public suspend fun voiceReceivers(values: List<Output<VoiceReceiverArgs>>) {
        this.voiceReceivers = Output.all(values)
    }

    /**
     * @param value The list of webhook receivers that are part of this action group.
     */
    @JvmName("itydtbytleqidexv")
    public suspend fun webhookReceivers(`value`: Output<List<WebhookReceiverArgs>>) {
        this.webhookReceivers = value
    }

    @JvmName("actvbnvarxvpnafc")
    public suspend fun webhookReceivers(vararg values: Output<WebhookReceiverArgs>) {
        this.webhookReceivers = Output.all(values.asList())
    }

    /**
     * @param values The list of webhook receivers that are part of this action group.
     */
    @JvmName("ngnmxtnpjdefdfgv")
    public suspend fun webhookReceivers(values: List<Output<WebhookReceiverArgs>>) {
        this.webhookReceivers = Output.all(values)
    }

    /**
     * @param value The name of the action group.
     */
    @JvmName("wixajxdfsrxkkimw")
    public suspend fun actionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionGroupName = mapped
    }

    /**
     * @param value The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("nxwukfcoyghhuyvi")
    public suspend fun armRoleReceivers(`value`: List<ArmRoleReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.armRoleReceivers = mapped
    }

    /**
     * @param argument The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("fduuhplxyugeaahe")
    public suspend
    fun armRoleReceivers(argument: List<suspend ArmRoleReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArmRoleReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.armRoleReceivers = mapped
    }

    /**
     * @param argument The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("mdcfilgfnlvbxbnb")
    public suspend fun armRoleReceivers(
        vararg
        argument: suspend ArmRoleReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ArmRoleReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.armRoleReceivers = mapped
    }

    /**
     * @param argument The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("vkrhvdeicwtfoaqp")
    public suspend fun armRoleReceivers(argument: suspend ArmRoleReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArmRoleReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.armRoleReceivers = mapped
    }

    /**
     * @param values The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
     */
    @JvmName("rnkriekovlgxygjf")
    public suspend fun armRoleReceivers(vararg values: ArmRoleReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.armRoleReceivers = mapped
    }

    /**
     * @param value The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("qvmepupppaklyfsu")
    public suspend fun automationRunbookReceivers(`value`: List<AutomationRunbookReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param argument The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("wnyhskotonsafxqg")
    public suspend
    fun automationRunbookReceivers(argument: List<suspend AutomationRunbookReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AutomationRunbookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param argument The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("yjbyohurfkiwcvro")
    public suspend fun automationRunbookReceivers(
        vararg
        argument: suspend AutomationRunbookReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AutomationRunbookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param argument The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("ltpcyfjvkjgndwjn")
    public suspend
    fun automationRunbookReceivers(argument: suspend AutomationRunbookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AutomationRunbookReceiverArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param values The list of AutomationRunbook receivers that are part of this action group.
     */
    @JvmName("rslauseytlmdwssj")
    public suspend fun automationRunbookReceivers(vararg values: AutomationRunbookReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.automationRunbookReceivers = mapped
    }

    /**
     * @param value The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("xptretppsiaxodkc")
    public suspend fun azureAppPushReceivers(`value`: List<AzureAppPushReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("yhjymawyhwqfarmr")
    public suspend
    fun azureAppPushReceivers(argument: List<suspend AzureAppPushReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureAppPushReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("sgfscggspjpjfhkg")
    public suspend fun azureAppPushReceivers(
        vararg
        argument: suspend AzureAppPushReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureAppPushReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param argument The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("vidihvjekandgerq")
    public suspend
    fun azureAppPushReceivers(argument: suspend AzureAppPushReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureAppPushReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param values The list of AzureAppPush receivers that are part of this action group.
     */
    @JvmName("qpogrrsktnhbckti")
    public suspend fun azureAppPushReceivers(vararg values: AzureAppPushReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureAppPushReceivers = mapped
    }

    /**
     * @param value The list of azure function receivers that are part of this action group.
     */
    @JvmName("ttocpebnndnfrmcv")
    public suspend fun azureFunctionReceivers(`value`: List<AzureFunctionReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param argument The list of azure function receivers that are part of this action group.
     */
    @JvmName("lffdjbynuwkpubqn")
    public suspend
    fun azureFunctionReceivers(argument: List<suspend AzureFunctionReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFunctionReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param argument The list of azure function receivers that are part of this action group.
     */
    @JvmName("qogyulaojhouutrl")
    public suspend fun azureFunctionReceivers(
        vararg
        argument: suspend AzureFunctionReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFunctionReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param argument The list of azure function receivers that are part of this action group.
     */
    @JvmName("ewcfbailjbkyuprf")
    public suspend
    fun azureFunctionReceivers(argument: suspend AzureFunctionReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureFunctionReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param values The list of azure function receivers that are part of this action group.
     */
    @JvmName("gvcurwadxakvulqk")
    public suspend fun azureFunctionReceivers(vararg values: AzureFunctionReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureFunctionReceivers = mapped
    }

    /**
     * @param value The list of email receivers that are part of this action group.
     */
    @JvmName("rlcdfwtkpjrspool")
    public suspend fun emailReceivers(`value`: List<EmailReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this action group.
     */
    @JvmName("ssbjxdwwgcacgbho")
    public suspend fun emailReceivers(argument: List<suspend EmailReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EmailReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this action group.
     */
    @JvmName("rvljlvoylcrnwnib")
    public suspend fun emailReceivers(vararg argument: suspend EmailReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EmailReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param argument The list of email receivers that are part of this action group.
     */
    @JvmName("vusvfbpnvscxnfnr")
    public suspend fun emailReceivers(argument: suspend EmailReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EmailReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.emailReceivers = mapped
    }

    /**
     * @param values The list of email receivers that are part of this action group.
     */
    @JvmName("onwqdebnkeyrebay")
    public suspend fun emailReceivers(vararg values: EmailReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailReceivers = mapped
    }

    /**
     * @param value Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
     */
    @JvmName("qjltglmaqypicqhb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The list of event hub receivers that are part of this action group.
     */
    @JvmName("jkrbusgtqetprbec")
    public suspend fun eventHubReceivers(`value`: List<EventHubReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubReceivers = mapped
    }

    /**
     * @param argument The list of event hub receivers that are part of this action group.
     */
    @JvmName("agfdugjljxryicyy")
    public suspend
    fun eventHubReceivers(argument: List<suspend EventHubReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventHubReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubReceivers = mapped
    }

    /**
     * @param argument The list of event hub receivers that are part of this action group.
     */
    @JvmName("eyqfqhvlqxnhgnsy")
    public suspend fun eventHubReceivers(
        vararg
        argument: suspend EventHubReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventHubReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubReceivers = mapped
    }

    /**
     * @param argument The list of event hub receivers that are part of this action group.
     */
    @JvmName("ptwwpowfjtwxigpg")
    public suspend fun eventHubReceivers(argument: suspend EventHubReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventHubReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.eventHubReceivers = mapped
    }

    /**
     * @param values The list of event hub receivers that are part of this action group.
     */
    @JvmName("ldecqycyqlgvdxpb")
    public suspend fun eventHubReceivers(vararg values: EventHubReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubReceivers = mapped
    }

    /**
     * @param value The short name of the action group. This will be used in SMS messages.
     */
    @JvmName("joixgdsccynlspus")
    public suspend fun groupShortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupShortName = mapped
    }

    /**
     * @param value The list of ITSM receivers that are part of this action group.
     */
    @JvmName("livduyiowpfiaipu")
    public suspend fun itsmReceivers(`value`: List<ItsmReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.itsmReceivers = mapped
    }

    /**
     * @param argument The list of ITSM receivers that are part of this action group.
     */
    @JvmName("rcubhhxhccgphkvf")
    public suspend fun itsmReceivers(argument: List<suspend ItsmReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ItsmReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.itsmReceivers = mapped
    }

    /**
     * @param argument The list of ITSM receivers that are part of this action group.
     */
    @JvmName("xwjsiyjiasgkyott")
    public suspend fun itsmReceivers(vararg argument: suspend ItsmReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ItsmReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.itsmReceivers = mapped
    }

    /**
     * @param argument The list of ITSM receivers that are part of this action group.
     */
    @JvmName("bmiawxerjmfjsrqm")
    public suspend fun itsmReceivers(argument: suspend ItsmReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ItsmReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.itsmReceivers = mapped
    }

    /**
     * @param values The list of ITSM receivers that are part of this action group.
     */
    @JvmName("aywsjcqbfihcqkla")
    public suspend fun itsmReceivers(vararg values: ItsmReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.itsmReceivers = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("osenbpiiwpxiaogg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The list of logic app receivers that are part of this action group.
     */
    @JvmName("irdfucymspujvskp")
    public suspend fun logicAppReceivers(`value`: List<LogicAppReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicAppReceivers = mapped
    }

    /**
     * @param argument The list of logic app receivers that are part of this action group.
     */
    @JvmName("omlxttjwibdehfgg")
    public suspend
    fun logicAppReceivers(argument: List<suspend LogicAppReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LogicAppReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logicAppReceivers = mapped
    }

    /**
     * @param argument The list of logic app receivers that are part of this action group.
     */
    @JvmName("rnymxnhuucrjifge")
    public suspend fun logicAppReceivers(
        vararg
        argument: suspend LogicAppReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LogicAppReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.logicAppReceivers = mapped
    }

    /**
     * @param argument The list of logic app receivers that are part of this action group.
     */
    @JvmName("bpixprsltwvqkrnk")
    public suspend fun logicAppReceivers(argument: suspend LogicAppReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LogicAppReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.logicAppReceivers = mapped
    }

    /**
     * @param values The list of logic app receivers that are part of this action group.
     */
    @JvmName("wrwoxqwincvtetlv")
    public suspend fun logicAppReceivers(vararg values: LogicAppReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logicAppReceivers = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cmchvwxpdnixigvm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of SMS receivers that are part of this action group.
     */
    @JvmName("xycsnqqegtbvltbi")
    public suspend fun smsReceivers(`value`: List<SmsReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this action group.
     */
    @JvmName("dxmbtpcqmopiyngn")
    public suspend fun smsReceivers(argument: List<suspend SmsReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SmsReceiverArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this action group.
     */
    @JvmName("ocixbmavkondhmte")
    public suspend fun smsReceivers(vararg argument: suspend SmsReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SmsReceiverArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param argument The list of SMS receivers that are part of this action group.
     */
    @JvmName("ijamksclsxljdiak")
    public suspend fun smsReceivers(argument: suspend SmsReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SmsReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.smsReceivers = mapped
    }

    /**
     * @param values The list of SMS receivers that are part of this action group.
     */
    @JvmName("kdjrbsiuvakgxsnl")
    public suspend fun smsReceivers(vararg values: SmsReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smsReceivers = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("nmgeyecfkamiaeqw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("hwlrvgdhusdjvhsg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The list of voice receivers that are part of this action group.
     */
    @JvmName("knncwdekmhdsscdf")
    public suspend fun voiceReceivers(`value`: List<VoiceReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this action group.
     */
    @JvmName("axwrncjquetavdqm")
    public suspend fun voiceReceivers(argument: List<suspend VoiceReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VoiceReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this action group.
     */
    @JvmName("dtaqejffmsjtwaxh")
    public suspend fun voiceReceivers(vararg argument: suspend VoiceReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VoiceReceiverArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param argument The list of voice receivers that are part of this action group.
     */
    @JvmName("iwaocbtsvtinkyxj")
    public suspend fun voiceReceivers(argument: suspend VoiceReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VoiceReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.voiceReceivers = mapped
    }

    /**
     * @param values The list of voice receivers that are part of this action group.
     */
    @JvmName("ghnjjogeyximuwam")
    public suspend fun voiceReceivers(vararg values: VoiceReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.voiceReceivers = mapped
    }

    /**
     * @param value The list of webhook receivers that are part of this action group.
     */
    @JvmName("atbkltyiuvykvlhw")
    public suspend fun webhookReceivers(`value`: List<WebhookReceiverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this action group.
     */
    @JvmName("wxsriyqyiclljrto")
    public suspend
    fun webhookReceivers(argument: List<suspend WebhookReceiverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this action group.
     */
    @JvmName("bkbckpnjxjfpfsyl")
    public suspend fun webhookReceivers(
        vararg
        argument: suspend WebhookReceiverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebhookReceiverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param argument The list of webhook receivers that are part of this action group.
     */
    @JvmName("cdkwgupuxritoyra")
    public suspend fun webhookReceivers(argument: suspend WebhookReceiverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookReceiverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.webhookReceivers = mapped
    }

    /**
     * @param values The list of webhook receivers that are part of this action group.
     */
    @JvmName("oyaahuehemmhbohd")
    public suspend fun webhookReceivers(vararg values: WebhookReceiverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookReceivers = mapped
    }

    internal fun build(): ActionGroupArgs = ActionGroupArgs(
        actionGroupName = actionGroupName,
        armRoleReceivers = armRoleReceivers,
        automationRunbookReceivers = automationRunbookReceivers,
        azureAppPushReceivers = azureAppPushReceivers,
        azureFunctionReceivers = azureFunctionReceivers,
        emailReceivers = emailReceivers,
        enabled = enabled,
        eventHubReceivers = eventHubReceivers,
        groupShortName = groupShortName,
        itsmReceivers = itsmReceivers,
        location = location,
        logicAppReceivers = logicAppReceivers,
        resourceGroupName = resourceGroupName,
        smsReceivers = smsReceivers,
        tags = tags,
        voiceReceivers = voiceReceivers,
        webhookReceivers = webhookReceivers,
    )
}
