@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.ActivityLogAlertArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.ActionListArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ActionListArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.AlertRuleAllOfConditionArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AlertRuleAllOfConditionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Activity Log Alert rule resource.
 * Azure REST API version: 2020-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2017-04-01, 2023-01-01-preview.
 * ## Example Usage
 * ### Create or update an Activity Log Alert rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityLogAlert = new AzureNative.Insights.ActivityLogAlert("activityLogAlert", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionListArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ActionGroupArgs
 *                 {
 *                     ActionGroupId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup",
 *                     WebhookProperties =
 *                     {
 *                         { "sampleWebhookProperty", "SamplePropertyValue" },
 *                     },
 *                 },
 *             },
 *         },
 *         ActivityLogAlertName = "SampleActivityLogAlertRule",
 *         Condition = new AzureNative.Insights.Inputs.AlertRuleAllOfConditionArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "Administrative",
 *                     Field = "category",
 *                 },
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "Error",
 *                     Field = "level",
 *                 },
 *             },
 *         },
 *         Description = "Description of sample Activity Log Alert rule.",
 *         Enabled = true,
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *         Scopes = new[]
 *         {
 *             "/subscriptions/187f412d-1758-44d9-b052-169e2564721d",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActivityLogAlert(ctx, "activityLogAlert", &insights.ActivityLogAlertArgs{
 * 			Actions: insights.ActionListResponse{
 * 				ActionGroups: insights.ActionGroupTypeArray{
 * 					&insights.ActionGroupTypeArgs{
 * 						ActionGroupId: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 * 						WebhookProperties: pulumi.StringMap{
 * 							"sampleWebhookProperty": pulumi.String("SamplePropertyValue"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ActivityLogAlertName: pulumi.String("SampleActivityLogAlertRule"),
 * 			Condition: insights.AlertRuleAllOfConditionResponse{
 * 				AllOf: insights.AlertRuleAnyOfOrLeafConditionArray{
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						Equals: pulumi.String("Administrative"),
 * 						Field:  pulumi.String("category"),
 * 					},
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						Equals: pulumi.String("Error"),
 * 						Field:  pulumi.String("level"),
 * 					},
 * 				},
 * 			},
 * 			Description:       pulumi.String("Description of sample Activity Log Alert rule."),
 * 			Enabled:           pulumi.Bool(true),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActivityLogAlert;
 * import com.pulumi.azurenative.insights.ActivityLogAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityLogAlert = new ActivityLogAlert("activityLogAlert", ActivityLogAlertArgs.builder()
 *             .actions(Map.of("actionGroups", Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("webhookProperties", Map.of("sampleWebhookProperty", "SamplePropertyValue"))
 *             )))
 *             .activityLogAlertName("SampleActivityLogAlertRule")
 *             .condition(Map.of("allOf",
 *                 Map.ofEntries(
 *                     Map.entry("equals", "Administrative"),
 *                     Map.entry("field", "category")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("equals", "Error"),
 *                     Map.entry("field", "level")
 *                 )))
 *             .description("Description of sample Activity Log Alert rule.")
 *             .enabled(true)
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopes("/subscriptions/187f412d-1758-44d9-b052-169e2564721d")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an Activity Log Alert rule with 'anyOf' condition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityLogAlert = new AzureNative.Insights.ActivityLogAlert("activityLogAlert", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionListArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ActionGroupArgs
 *                 {
 *                     ActionGroupId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup",
 *                     WebhookProperties =
 *                     {
 *                         { "sampleWebhookProperty", "SamplePropertyValue" },
 *                     },
 *                 },
 *             },
 *         },
 *         ActivityLogAlertName = "SampleActivityLogAlertRuleWithAnyOfCondition",
 *         Condition = new AzureNative.Insights.Inputs.AlertRuleAllOfConditionArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "ServiceHealth",
 *                     Field = "category",
 *                 },
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     AnyOf = new[]
 *                     {
 *                         new AzureNative.Insights.Inputs.AlertRuleLeafConditionArgs
 *                         {
 *                             Equals = "Incident",
 *                             Field = "properties.incidentType",
 *                         },
 *                         new AzureNative.Insights.Inputs.AlertRuleLeafConditionArgs
 *                         {
 *                             Equals = "Maintenance",
 *                             Field = "properties.incidentType",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Description = "Description of sample Activity Log Alert rule with 'anyOf' condition.",
 *         Enabled = true,
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *         Scopes = new[]
 *         {
 *             "subscriptions/187f412d-1758-44d9-b052-169e2564721d",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := insights.NewActivityLogAlert(ctx, "activityLogAlert", &insights.ActivityLogAlertArgs{
 * Actions: insights.ActionListResponse{
 * ActionGroups: insights.ActionGroupTypeArray{
 * &insights.ActionGroupTypeArgs{
 * ActionGroupId: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 * WebhookProperties: pulumi.StringMap{
 * "sampleWebhookProperty": pulumi.String("SamplePropertyValue"),
 * },
 * },
 * },
 * },
 * ActivityLogAlertName: pulumi.String("SampleActivityLogAlertRuleWithAnyOfCondition"),
 * Condition: insights.AlertRuleAllOfConditionResponse{
 * AllOf: insights.AlertRuleAnyOfOrLeafConditionArray{
 * &insights.AlertRuleAnyOfOrLeafConditionArgs{
 * Equals: pulumi.String("ServiceHealth"),
 * Field: pulumi.String("category"),
 * },
 * interface{}{
 * AnyOf: insights.AlertRuleLeafConditionArray{
 * &insights.AlertRuleLeafConditionArgs{
 * Equals: pulumi.String("Incident"),
 * Field: pulumi.String("properties.incidentType"),
 * },
 * &insights.AlertRuleLeafConditionArgs{
 * Equals: pulumi.String("Maintenance"),
 * Field: pulumi.String("properties.incidentType"),
 * },
 * },
 * },
 * },
 * },
 * Description: pulumi.String("Description of sample Activity Log Alert rule with 'anyOf' condition."),
 * Enabled: pulumi.Bool(true),
 * Location: pulumi.String("Global"),
 * ResourceGroupName: pulumi.String("MyResourceGroup"),
 * Scopes: pulumi.StringArray{
 * pulumi.String("subscriptions/187f412d-1758-44d9-b052-169e2564721d"),
 * },
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActivityLogAlert;
 * import com.pulumi.azurenative.insights.ActivityLogAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityLogAlert = new ActivityLogAlert("activityLogAlert", ActivityLogAlertArgs.builder()
 *             .actions(Map.of("actionGroups", Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("webhookProperties", Map.of("sampleWebhookProperty", "SamplePropertyValue"))
 *             )))
 *             .activityLogAlertName("SampleActivityLogAlertRuleWithAnyOfCondition")
 *             .condition(Map.of("allOf",
 *                 Map.ofEntries(
 *                     Map.entry("equals", "ServiceHealth"),
 *                     Map.entry("field", "category")
 *                 ),
 *                 Map.of("anyOf",
 *                     Map.ofEntries(
 *                         Map.entry("equals", "Incident"),
 *                         Map.entry("field", "properties.incidentType")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("equals", "Maintenance"),
 *                         Map.entry("field", "properties.incidentType")
 *                     ))))
 *             .description("Description of sample Activity Log Alert rule with 'anyOf' condition.")
 *             .enabled(true)
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopes("subscriptions/187f412d-1758-44d9-b052-169e2564721d")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an Activity Log Alert rule with 'containsAny'
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activityLogAlert = new AzureNative.Insights.ActivityLogAlert("activityLogAlert", new()
 *     {
 *         Actions = new AzureNative.Insights.Inputs.ActionListArgs
 *         {
 *             ActionGroups = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.ActionGroupArgs
 *                 {
 *                     ActionGroupId = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup",
 *                     WebhookProperties =
 *                     {
 *                         { "sampleWebhookProperty", "SamplePropertyValue" },
 *                     },
 *                 },
 *             },
 *         },
 *         ActivityLogAlertName = "SampleActivityLogAlertRuleWithContainsAny",
 *         Condition = new AzureNative.Insights.Inputs.AlertRuleAllOfConditionArgs
 *         {
 *             AllOf = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     Equals = "ServiceHealth",
 *                     Field = "category",
 *                 },
 *                 new AzureNative.Insights.Inputs.AlertRuleAnyOfOrLeafConditionArgs
 *                 {
 *                     ContainsAny = new[]
 *                     {
 *                         "North Europe",
 *                         "West Europe",
 *                     },
 *                     Field = "properties.impactedServices[*].ImpactedRegions[*].RegionName",
 *                 },
 *             },
 *         },
 *         Description = "Description of sample Activity Log Alert rule with 'containsAny'.",
 *         Enabled = true,
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *         Scopes = new[]
 *         {
 *             "subscriptions/187f412d-1758-44d9-b052-169e2564721d",
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewActivityLogAlert(ctx, "activityLogAlert", &insights.ActivityLogAlertArgs{
 * 			Actions: insights.ActionListResponse{
 * 				ActionGroups: insights.ActionGroupTypeArray{
 * 					&insights.ActionGroupTypeArgs{
 * 						ActionGroupId: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 * 						WebhookProperties: pulumi.StringMap{
 * 							"sampleWebhookProperty": pulumi.String("SamplePropertyValue"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ActivityLogAlertName: pulumi.String("SampleActivityLogAlertRuleWithContainsAny"),
 * 			Condition: insights.AlertRuleAllOfConditionResponse{
 * 				AllOf: insights.AlertRuleAnyOfOrLeafConditionArray{
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						Equals: pulumi.String("ServiceHealth"),
 * 						Field:  pulumi.String("category"),
 * 					},
 * 					&insights.AlertRuleAnyOfOrLeafConditionArgs{
 * 						ContainsAny: pulumi.StringArray{
 * 							pulumi.String("North Europe"),
 * 							pulumi.String("West Europe"),
 * 						},
 * 						Field: pulumi.String("properties.impactedServices[*].ImpactedRegions[*].RegionName"),
 * 					},
 * 				},
 * 			},
 * 			Description:       pulumi.String("Description of sample Activity Log Alert rule with 'containsAny'."),
 * 			Enabled:           pulumi.Bool(true),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("subscriptions/187f412d-1758-44d9-b052-169e2564721d"),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ActivityLogAlert;
 * import com.pulumi.azurenative.insights.ActivityLogAlertArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activityLogAlert = new ActivityLogAlert("activityLogAlert", ActivityLogAlertArgs.builder()
 *             .actions(Map.of("actionGroups", Map.ofEntries(
 *                 Map.entry("actionGroupId", "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("webhookProperties", Map.of("sampleWebhookProperty", "SamplePropertyValue"))
 *             )))
 *             .activityLogAlertName("SampleActivityLogAlertRuleWithContainsAny")
 *             .condition(Map.of("allOf",
 *                 Map.ofEntries(
 *                     Map.entry("equals", "ServiceHealth"),
 *                     Map.entry("field", "category")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("containsAny",
 *                         "North Europe",
 *                         "West Europe"),
 *                     Map.entry("field", "properties.impactedServices[*].ImpactedRegions[*].RegionName")
 *                 )))
 *             .description("Description of sample Activity Log Alert rule with 'containsAny'.")
 *             .enabled(true)
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopes("subscriptions/187f412d-1758-44d9-b052-169e2564721d")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ActivityLogAlert SampleActivityLogAlertRuleWithContainsAny /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/activityLogAlerts/{activityLogAlertName}
 * ```
 * @property actions The actions that will activate when the condition is met.
 * @property activityLogAlertName The name of the Activity Log Alert rule.
 * @property condition The condition that will cause this alert to activate.
 * @property description A description of this Activity Log Alert rule.
 * @property enabled Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
 * @property location The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopes A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
 * @property tags The tags of the resource.
 */
public data class ActivityLogAlertArgs(
    public val actions: Output<ActionListArgs>? = null,
    public val activityLogAlertName: Output<String>? = null,
    public val condition: Output<AlertRuleAllOfConditionArgs>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.ActivityLogAlertArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.ActivityLogAlertArgs =
        com.pulumi.azurenative.insights.ActivityLogAlertArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .activityLogAlertName(activityLogAlertName?.applyValue({ args0 -> args0 }))
            .condition(condition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ActivityLogAlertArgs].
 */
@PulumiTagMarker
public class ActivityLogAlertArgsBuilder internal constructor() {
    private var actions: Output<ActionListArgs>? = null

    private var activityLogAlertName: Output<String>? = null

    private var condition: Output<AlertRuleAllOfConditionArgs>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The actions that will activate when the condition is met.
     */
    @JvmName("rpyogovuuuphtmus")
    public suspend fun actions(`value`: Output<ActionListArgs>) {
        this.actions = value
    }

    /**
     * @param value The name of the Activity Log Alert rule.
     */
    @JvmName("kwkwaaoybgfmhkkt")
    public suspend fun activityLogAlertName(`value`: Output<String>) {
        this.activityLogAlertName = value
    }

    /**
     * @param value The condition that will cause this alert to activate.
     */
    @JvmName("bfebltbjjhxpxbjr")
    public suspend fun condition(`value`: Output<AlertRuleAllOfConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value A description of this Activity Log Alert rule.
     */
    @JvmName("hyobaaxpakxhoaky")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
     */
    @JvmName("sxiexsjpexpevcds")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
     */
    @JvmName("ekgbcboopoegngyw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ummvyqpxyubbsarg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
     */
    @JvmName("dcfmivxttnlbovlj")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("mjshtpaxcsenqtvf")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
     */
    @JvmName("xbkooiuvxjcnodbo")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ilshtjfeqwmdsesh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The actions that will activate when the condition is met.
     */
    @JvmName("eaoaolleniemtsho")
    public suspend fun actions(`value`: ActionListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument The actions that will activate when the condition is met.
     */
    @JvmName("jljbnlydundgshpe")
    public suspend fun actions(argument: suspend ActionListArgsBuilder.() -> Unit) {
        val toBeMapped = ActionListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param value The name of the Activity Log Alert rule.
     */
    @JvmName("eakiiqxuyrbrnftl")
    public suspend fun activityLogAlertName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activityLogAlertName = mapped
    }

    /**
     * @param value The condition that will cause this alert to activate.
     */
    @JvmName("youdldfwfalsajmf")
    public suspend fun condition(`value`: AlertRuleAllOfConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument The condition that will cause this alert to activate.
     */
    @JvmName("thbmrfkkwnxniboc")
    public suspend fun condition(argument: suspend AlertRuleAllOfConditionArgsBuilder.() -> Unit) {
        val toBeMapped = AlertRuleAllOfConditionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value A description of this Activity Log Alert rule.
     */
    @JvmName("bmiuqhkagxqojxpg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
     */
    @JvmName("gfsjvuxdswpuwdcb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
     */
    @JvmName("uqtshbmoconlwkpl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fteethxcpmetdyse")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
     */
    @JvmName("wuaxwghaikvremxc")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
     */
    @JvmName("prhhpxkcjorweruq")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("jytpwuqbjdpadyor")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("bnlvfuqroyuphxqf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ActivityLogAlertArgs = ActivityLogAlertArgs(
        actions = actions,
        activityLogAlertName = activityLogAlertName,
        condition = condition,
        description = description,
        enabled = enabled,
        location = location,
        resourceGroupName = resourceGroupName,
        scopes = scopes,
        tags = tags,
    )
}
